/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import io.cronapp.ContextManager;
import io.cronapp.xml.Parameter;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-context-xml", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ProcessContextXmlMojo
extends AbstractGenerateFiles {
    @org.apache.maven.plugins.annotations.Parameter(property="cronapp.profile")
    protected String profile;
    @org.apache.maven.plugins.annotations.Parameter(property="cronapp.useContext", defaultValue="true")
    protected Boolean useContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isCronappIDE()) {
            return;
        }
        MavenProject project = this.getMavenProject();
        File outputDirectory = this.getExplodedFolder();
        File contextFolder = new File(outputDirectory, "META-INF");
        File contextFile = new File(contextFolder, "context.xml");
        contextFolder.mkdirs();
        try {
            this.handleContext(contextFile.toPath());
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        Resource resource = new Resource();
        resource.setDirectory(outputDirectory.getPath());
        resource.addInclude("**" + File.separator + "context.xml");
        project.addResource(resource);
    }

    private void handleContext(Path targetContext) throws Exception {
        Path sourceContext = this.getMavenProject().getBasedir().toPath().resolve("config").resolve("context.xml");
        if (Files.exists(sourceContext, new LinkOption[0]) && targetContext != null) {
            ContextManager contextManager;
            try (InputStream in = Files.newInputStream(sourceContext, new OpenOption[0]);){
                contextManager = new ContextManager(in);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.profile)) {
                this.getLog().info((CharSequence)("Setting profile " + this.profile));
                contextManager.updateProfile(this.profile);
                contextManager.createOrReplaceParameter(new Parameter("app.profile", this.profile), "app.profile");
            }
            this.getLog().info((CharSequence)"Cleaning up context.xml");
            contextManager.cleanDuplicated();
            if (!this.useContext.booleanValue()) {
                this.getLog().info((CharSequence)"Cleaning up datasources");
                contextManager.cleanDatasources();
            }
            contextManager.saveTo(targetContext);
        }
    }
}

