/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import io.cronapp.persistence.PersistenceManager;
import io.cronapp.persistence.model.Persistence;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-persistence-xml", defaultPhase=LifecyclePhase.PACKAGE)
public class ProcessPersistenceXmlMojo
extends AbstractGenerateFiles {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="cronapp.generationType", defaultValue="auto")
    protected String generationType;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.generationType.equals("auto")) {
            return;
        }
        File targetFolder = new File(this.getMavenProject().getBuild().getDirectory());
        File jarFile = new File(targetFolder, this.getMavenProject().getBuild().getFinalName() + ".war");
        File explodedFolder = new File(targetFolder, this.getMavenProject().getBuild().getFinalName());
        try {
            URI zipURI = new URI("jar", jarFile.toURI().toString(), null);
            HashMap<String, String> zipProperties = new HashMap<String, String>();
            zipProperties.put("create", "false");
            try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
                Path persistencePath = zipFS.getPath("WEB-INF/classes/META-INF/persistence.xml", new String[0]);
                this.handleGenerationType(persistencePath);
            }
            try {
                if (explodedFolder.exists()) {
                    Path persistencePath = new File(explodedFolder, "WEB-INF/classes/META-INF/persistence.xml").toPath();
                    this.handleGenerationType(persistencePath);
                }
            }
            catch (Throwable e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void handleGenerationType(Path persistencePath) throws Exception {
        if (persistencePath != null && Files.exists(persistencePath, new LinkOption[0])) {
            Persistence persistence;
            PersistenceManager persistenceManager = new PersistenceManager();
            try (InputStream in = Files.newInputStream(persistencePath, new OpenOption[0]);){
                persistence = persistenceManager.getPersistence(in);
            }
            this.getLog().info((CharSequence)("Setting generationType to " + this.generationType));
            persistenceManager.setGenerationType(persistence, this.generationType);
            persistenceManager.saveAs(persistence, persistencePath);
        }
    }
}

