/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp;

import io.cronapp.AbstractGenerateFiles;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="process-populate-json", defaultPhase=LifecyclePhase.PACKAGE)
public class ProcessPopulateJsonMojo
extends AbstractGenerateFiles {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="cronapp.populate", defaultValue="true")
    protected Boolean populate;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.populate.booleanValue()) {
            return;
        }
        File targetFolder = new File(this.getMavenProject().getBuild().getDirectory());
        File jarFile = new File(targetFolder, this.getMavenProject().getBuild().getFinalName() + ".war");
        File explodedFolder = new File(targetFolder, this.getMavenProject().getBuild().getFinalName());
        try {
            URI zipURI = new URI("jar", jarFile.toURI().toString(), null);
            HashMap<String, String> zipProperties = new HashMap<String, String>();
            zipProperties.put("create", "false");
            try (FileSystem zipFS = FileSystems.newFileSystem(zipURI, zipProperties);){
                Path root = zipFS.getPath("WEB-INF/classes/", new String[0]);
                this.handlePopulate(root);
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        try {
            if (explodedFolder.exists()) {
                Path root = new File(explodedFolder, "WEB-INF/classes/").toPath();
                this.handlePopulate(root);
            }
        }
        catch (Throwable e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void handlePopulate(Path root) throws IOException {
        Files.find(root, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.toString().endsWith("populate.json"), new FileVisitOption[0]).forEach(path -> {
            try {
                this.getLog().info((CharSequence)("Removing " + path));
                Files.delete(path);
            }
            catch (IOException e1) {
                this.getLog().error((Throwable)e1);
            }
        });
    }
}

