/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.extensions;

import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;

public class GenerateFilesExtensions {
    public static void save(File parentFolder, String contentFile, String filename) throws IOException {
        File file = new File(parentFolder, filename);
        file.getParentFile().mkdirs();
        FileUtils.write((File)file, (CharSequence)contentFile, (Charset)StandardCharsets.UTF_8);
    }

    public static Boolean isNull(JsonElement value) {
        return value == null || value.isJsonNull();
    }

    public static String safeNameForMethodBlockly(String blocklyMethod) {
        if (blocklyMethod == null || blocklyMethod.isBlank()) {
            return "unnamed";
        }
        Object result = URLEncoder.encode(blocklyMethod = blocklyMethod.trim().replace(" ", "_"), StandardCharsets.UTF_8).replaceAll("[^\\w]", "_");
        if ("0123456789".indexOf(((String)result).substring(0, 1)) > -1) {
            result = "my_" + (String)result;
        }
        return result;
    }

    public static void addToGitIgnore(MavenProject mavenProject, String content) throws IOException {
        File projectRootDirectory = mavenProject.getBasedir();
        Path gitIgnorePath = projectRootDirectory.toPath().resolve(".gitignore");
        if (!Files.exists(gitIgnorePath, new LinkOption[0])) {
            Files.createFile(gitIgnorePath, new FileAttribute[0]);
        }
        File gitIgnoreFile = gitIgnorePath.toFile();
        List<String> lines = Files.readAllLines(gitIgnorePath);
        String ignoredFile = projectRootDirectory.toPath().relativize(Path.of(content, new String[0])).toString();
        if (lines.stream().filter(line -> line.equals(ignoredFile)).findFirst().isEmpty()) {
            try (FileWriter writer = new FileWriter(gitIgnoreFile, true);
                 BufferedWriter bufferedWriter = new BufferedWriter(writer);){
                bufferedWriter.newLine();
                bufferedWriter.write(ignoredFile);
            }
        }
    }
}

