<#--noinspection FtlReferencesInspection-->
<#list tokenRegistrations as tokenRegistration>
#region ${tokenRegistration.name}
cronapp.token.client.registration.${tokenRegistration.id}.id=${tokenRegistration.id}
cronapp.token.client.registration.${tokenRegistration.id}.type=${tokenRegistration.type}
    <#list tokenRegistration.resourceServerUrls as resourceServerUrl>
cronapp.token.client.registration.${tokenRegistration.id}.resourceServerUrls.${resourceServerUrl?index}=${resourceServerUrl.url}
    </#list>
    <#if tokenRegistration.type == 'OAUTH2'>
        <#if tokenRegistration.configuration.grantType == 'CLIENT_CREDENTIALS'>
spring.security.oauth2.client.registration.${tokenRegistration.id}.client-id=${tokenRegistration.configuration.clientId}
spring.security.oauth2.client.registration.${tokenRegistration.id}.client-secret=${tokenRegistration.configuration.clientSecret}
spring.security.oauth2.client.registration.${tokenRegistration.id}.authorization-grant-type=client_credentials
spring.security.oauth2.client.registration.${tokenRegistration.id}.client-authentication-method=${tokenRegistration.configuration.authenticationMethod}
spring.security.oauth2.client.provider.${tokenRegistration.id}.token-uri=${tokenRegistration.configuration.tokenUri}
        </#if>
    </#if>
    <#if tokenRegistration.type == 'API_KEY'>
cronapp.token.client.registration.${tokenRegistration.id}.apiKeyName=${tokenRegistration.configuration.name}
cronapp.token.client.registration.${tokenRegistration.id}.apiKeyIn=${tokenRegistration.configuration.in}
cronapp.token.client.registration.${tokenRegistration.id}.apiKeyValue=${tokenRegistration.configuration.value}
    </#if>
#endregion ${tokenRegistration.name}

</#list>