/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.fs;

import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.fs.FileSystemResource;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.activation.DataSource;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileSystemService {
    public static final String DEFAULT_FILE_SYSTEM = "default";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private FileObject getFileSystemRoot(String fileSystemName) throws CronappFrameworkException {
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            return fileSystemManager.resolveFile("file:///");
        }
        catch (FileSystemException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    public Stream<String> list(String directoryName) throws CronappFrameworkException {
        return this.list(directoryName, DEFAULT_FILE_SYSTEM);
    }

    public Stream<String> list(String directoryName, String fileSystemName) throws CronappFrameworkException {
        try {
            return Arrays.stream(this.getFileSystemRoot(fileSystemName).getChild(directoryName).getChildren()).map(FileObject::getName).map(FileName::getPath);
        }
        catch (FileSystemException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    public Stream<String> listFiles(String path) throws CronappFrameworkException {
        return this.listFiles(path, DEFAULT_FILE_SYSTEM);
    }

    public Stream<String> listFiles(String path, String fileSystem) throws CronappFrameworkException {
        try {
            FileObject[] children = this.getFileSystemRoot(fileSystem).getChild(path).getChildren();
            return Arrays.stream(children).filter(this::testIsFile).map(FileObject::getName).map(FileName::getPath);
        }
        catch (FileSystemException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    public Stream<String> listDirectories(String path) throws CronappFrameworkException {
        return this.listDirectories(path, DEFAULT_FILE_SYSTEM);
    }

    public Stream<String> listDirectories(String path, String fileSystem) throws CronappFrameworkException {
        try {
            FileObject[] children = this.getFileSystemRoot(fileSystem).getChild(path).getChildren();
            return Arrays.stream(children).filter(this::testIsDirectory).map(FileObject::getName).map(FileName::getPath);
        }
        catch (FileSystemException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    public DataSource open(String path) throws CronappFrameworkException {
        return this.open(path, DEFAULT_FILE_SYSTEM);
    }

    public DataSource open(String path, String fileSystem) throws CronappFrameworkException {
        try {
            FileObject object = this.getFileSystemRoot(fileSystem).resolveFile(path);
            return new FileSystemResource(object);
        }
        catch (FileSystemException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }

    private boolean testIsFile(FileObject fileObject) {
        try {
            return fileObject.isFile();
        }
        catch (FileSystemException e) {
            this.logger.debug("Error checking if is file " + fileObject.getName().getPath(), (Throwable)e);
            return false;
        }
    }

    private boolean testIsDirectory(FileObject fileObject) {
        try {
            return fileObject.isFolder();
        }
        catch (FileSystemException e) {
            this.logger.debug("Error checking if is file " + fileObject.getName().getPath(), (Throwable)e);
            return false;
        }
    }
}

