/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemResource
implements DataSource {
    private final FileObject fileObject;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FileSystemResource(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    FileObject getFileObject() {
        return this.fileObject;
    }

    public InputStream getInputStream() throws IOException {
        return this.fileObject.getContent().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.fileObject.getContent().getOutputStream();
    }

    public String getContentType() {
        String type = null;
        try {
            type = this.fileObject.getContent().getContentInfo().getContentType();
        }
        catch (FileSystemException e) {
            this.logger.debug("Error getting content type", (Throwable)e);
        }
        if (type == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public String getName() {
        return this.fileObject.getName().getBaseName();
    }
}

