/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.token.google;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"success", "challenge_ts", "hostname", "error-codes"})
public class GoogleResponse {
    @JsonProperty(value="success")
    private boolean success;
    @JsonProperty(value="challenge_ts")
    private String challengeTs;
    @JsonProperty(value="hostname")
    private String hostname;
    @JsonProperty(value="error-codes")
    private ErrorCode[] errorCodes;

    @JsonProperty(value="success")
    public boolean isSuccess() {
        return this.success;
    }

    @JsonProperty(value="success")
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @JsonProperty(value="challenge_ts")
    public String getChallengeTs() {
        return this.challengeTs;
    }

    @JsonProperty(value="challenge_ts")
    public void setChallengeTs(String challengeTs) {
        this.challengeTs = challengeTs;
    }

    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty(value="hostname")
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty(value="error-codes")
    public void setErrorCodes(ErrorCode[] errorCodes) {
        this.errorCodes = errorCodes;
    }

    @JsonProperty(value="error-codes")
    public ErrorCode[] getErrorCodes() {
        return this.errorCodes;
    }

    @JsonIgnore
    public boolean hasClientError() {
        ErrorCode[] errors = this.getErrorCodes();
        if (errors == null) {
            return false;
        }
        for (ErrorCode error : errors) {
            switch (error) {
                case InvalidResponse: 
                case MissingResponse: {
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "GoogleResponse{success=" + this.success + ", challengeTs='" + this.challengeTs + "', hostname='" + this.hostname + "', errorCodes=" + Arrays.toString((Object[])this.errorCodes) + "}";
    }

    static enum ErrorCode {
        MissingSecret,
        InvalidSecret,
        MissingResponse,
        InvalidResponse;

        private static Map<String, ErrorCode> errorsMap;

        @JsonCreator
        public static ErrorCode forValue(String value) {
            return errorsMap.get(value.toLowerCase());
        }

        static {
            errorsMap = new HashMap<String, ErrorCode>(4);
            errorsMap.put("missing-input-secret", MissingSecret);
            errorsMap.put("invalid-input-secret", InvalidSecret);
            errorsMap.put("missing-input-response", MissingResponse);
            errorsMap.put("invalid-input-response", InvalidResponse);
        }
    }
}

