/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.persistence;

import cronapi.AppConfig;
import cronapp.framework.CronappFrameworkException;
import cronapp.framework.i18n.Messages;
import cronapp.framework.persistence.PasswordEncoder;
import cronapp.framework.persistence.PasswordHistoryRule;
import cronapp.framework.persistence.ValidPassword;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.PropertyUtils;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.ResourceBundleMessageResolver;
import org.passay.RuleResult;
import org.passay.SequenceData;
import org.passay.WhitespaceRule;

public class PasswordConstraintValidator
implements ConstraintValidator<ValidPassword, Object> {
    private String passwordProperty;
    private String passwordHistoryProperty;

    public void initialize(ValidPassword annotation) {
        this.passwordProperty = annotation.passwordProperty();
        this.passwordHistoryProperty = annotation.passwordHistoryProperty();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ArrayList passwordHistory;
        String password;
        if (this.passwordProperty == null) {
            return true;
        }
        try {
            Object passwordPropertyValue = PropertyUtils.getProperty((Object)value, (String)this.passwordProperty);
            password = passwordPropertyValue != null ? passwordPropertyValue.toString() : "";
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CronappFrameworkException("Error getting password property value", e);
        }
        try {
            Object passwordHistoryValue = PropertyUtils.getProperty((Object)value, (String)this.passwordHistoryProperty);
            String rawPasswordHistory = passwordHistoryValue != null ? passwordHistoryValue.toString() : null;
            passwordHistory = rawPasswordHistory == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(rawPasswordHistory.split(",")));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CronappFrameworkException("Error getting password history property value", e);
        }
        if (PasswordEncoder.getPasswordEncoder().isEncoded(password)) {
            return true;
        }
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new LengthRule(AppConfig.getMinPasswordSize().intValue(), 16));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, AppConfig.getMinUpperCase().intValue()));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Digit, AppConfig.getMinDigit().intValue()));
        rules.add(new CharacterRule((CharacterData)EnglishCharacterData.Special, AppConfig.getMinSpecial().intValue()));
        if (AppConfig.getOnlyStrongPass().booleanValue()) {
            rules.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.Numerical, 3, false));
            rules.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.Alphabetical, 3, false));
            rules.add(new IllegalSequenceRule((SequenceData)EnglishSequenceData.USQwerty, 3, false));
            rules.add(new WhitespaceRule());
        }
        if (AppConfig.getDontAllowRepeatedPass().booleanValue()) {
            rules.add((Object)new PasswordHistoryRule());
        }
        PasswordData passwordData = new PasswordData(password);
        List passwordReferences = passwordHistory.stream().map(PasswordData.HistoricalReference::new).collect(Collectors.toUnmodifiableList());
        passwordData.setPasswordReferences(passwordReferences);
        ResourceBundle resourceBundle = Messages.RESOURCE_BUNDLE.get();
        PropertiesMessageResolver resolver = resourceBundle == null ? new PropertiesMessageResolver() : new ResourceBundleMessageResolver(Messages.RESOURCE_BUNDLE.get());
        PasswordValidator validator = new PasswordValidator((MessageResolver)resolver, rules);
        RuleResult result = validator.validate(passwordData);
        if (result.isValid()) {
            return true;
        }
        context.disableDefaultConstraintViolation();
        validator.getMessages(result).forEach(message -> context.buildConstraintViolationWithTemplate(message).addConstraintViolation());
        return false;
    }
}

