/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.authentication.external.ActiveDirectoryUserDetailsMapper;
import cronapp.framework.authentication.external.BasedInLdapAuthenticator;
import java.util.LinkedHashMap;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

class ActiveDirectoryAuthenticator
extends BasedInLdapAuthenticator {
    ActiveDirectoryAuthenticator() {
    }

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        ActiveDirectoryLdapAuthenticationProvider provider = new ActiveDirectoryLdapAuthenticationProvider(AppConfig.defaultDomain(), this.generateProviderUrl());
        provider.setSearchFilter("(&(objectClass=user)(sAMAccountName={1}))");
        provider.setUserDetailsContextMapper((UserDetailsContextMapper)new ActiveDirectoryUserDetailsMapper(AppConfig.defaultDomain()));
        if (this.generateProviderUrl().startsWith("ldaps")) {
            LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
            environment.put("java.naming.ldap.factory.socket", "cronapp.framework.authentication.external.AcceptAllSSLSocketFactory");
            provider.setContextEnvironmentProperties(environment);
        }
        return provider.authenticate(authentication);
    }
}

