/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.normal;

import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapp.framework.LockedUserException;
import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.external.ExternalAuthenticationConfig;
import cronapp.framework.authentication.security.CronappUserDetails;
import cronapp.framework.authentication.social.SocialConfig;
import cronapp.framework.authentication.token.google.CaptchaVerify;
import cronapp.framework.i18n.Messages;
import cronapp.framework.tenant.TenantComponent;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AuthenticationConfigurer
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationConfigurer.class);
    private HttpServletRequest request;
    private TenantComponent tenantComponent;
    private final CaptchaVerify captchaVerify;

    public AuthenticationConfigurer(HttpServletRequest request, @Nullable TenantComponent tenantComponent) {
        this.request = request;
        this.tenantComponent = tenantComponent;
        this.captchaVerify = new CaptchaVerify();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Messages.set(this.request.getLocale());
            String name = authentication.getName();
            boolean isOauth = authentication.getAuthorities().contains(new SimpleGrantedAuthority("#OAUTH#"));
            String rawPassword = authentication.getCredentials().toString();
            String type = null;
            boolean autoSignUp = false;
            boolean externalAuthenticationSuccess = false;
            if (isOauth) {
                type = rawPassword;
                autoSignUp = SocialConfig.isAutoSignUp();
            }
            if (name.equals("#OAUTH#") && this.request.getSession().getAttribute("#OAUTH#USER") != null) {
                name = (String)this.request.getSession().getAttribute("#OAUTH#USER");
                isOauth = true;
                this.request.getSession().removeAttribute("#OAUTH#USER");
            }
            Authentication externalToken = null;
            CronappUserDetails externalUserDetails = null;
            if (ExternalAuthenticationConfig.isExternalAuth()) {
                externalToken = ExternalAuthenticationConfig.authenticateExternally((Authentication)new UsernamePasswordAuthenticationToken((Object)name, (Object)rawPassword));
                type = ExternalAuthenticationConfig.getExternalAuthType();
                externalAuthenticationSuccess = true;
                boolean bl = autoSignUp = autoSignUp || AppConfig.autoSignUp();
                if (externalToken.getPrincipal() instanceof CronappUserDetails) {
                    externalUserDetails = (CronappUserDetails)externalToken.getPrincipal();
                }
            }
            ApiManager apiManager = ApiManager.byUserAndPassword(name, rawPassword, type, autoSignUp, authentication.getDetails() instanceof JsonObject ? (JsonObject)authentication.getDetails() : null);
            if (authentication instanceof UsernamePasswordAuthenticationToken) {
                ((UsernamePasswordAuthenticationToken)authentication).setDetails(null);
            }
            cronapp.framework.api.User userNoPassword = null;
            try {
                userNoPassword = ApiManager.byUser(name).getUser();
                if (ApiManager.isUserLocked(userNoPassword)) {
                    throw new LockedUserException(Messages.getString("UserLocked"));
                }
                this.verifyRecaptcha(name, this.request);
                cronapp.framework.api.User user = apiManager.getUser(externalUserDetails);
                if (user == null) {
                    throw new UsernameNotFoundException(Messages.getString("UserNotFound"));
                }
                if (ExternalAuthenticationConfig.isExternalAuth() && !isOauth && !externalAuthenticationSuccess) {
                    throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
                }
                String password = user.getPassword();
                if (!(ExternalAuthenticationConfig.isExternalAuth() || isOauth || apiManager.passwordMatches(rawPassword, password))) {
                    throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
                }
                Collection<Object> authorities = externalUserDetails == null ? apiManager.getAuthorities() : externalUserDetails.getAuthorities();
                User userDetails = new User(name, rawPassword, false, false, false, false, authorities);
                UsernamePasswordAuthenticationToken userToken = new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, authorities);
                userToken.setDetails((Object)userDetails);
                String theme = user.getTheme();
                if (theme == null) {
                    theme = "";
                }
                HttpSession session = this.request.getSession();
                session.setAttribute("theme", (Object)theme);
                this.request.setAttribute("userDetails", (Object)user);
                if (this.tenantComponent != null) {
                    this.tenantComponent.authenticationTenant(user.getUsername());
                }
                ApiManager.unlockUser(userNoPassword);
                UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = userToken;
                return usernamePasswordAuthenticationToken;
            }
            catch (Exception e) {
                ApiManager.attemptFailed(userNoPassword);
                if (!ApiManager.isUserLocked(userNoPassword) && ApiManager.getFailedAttempts(userNoPassword) > AppConfig.getFailedAttempts()) {
                    ApiManager.lockUser(userNoPassword);
                }
                log.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
                throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
            }
        }
        finally {
            Messages.remove();
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    private void verifyRecaptcha(String username, HttpServletRequest request) {
        try {
            Assert.isTrue((boolean)this.captchaVerify.processRequest(username, request), (String)"");
        }
        catch (Exception e) {
            log.error(Messages.getString("AuthError", e.getMessage()), (Throwable)e);
            throw new AuthenticationServiceException(Messages.getString("AuthError", e.getMessage()));
        }
    }
}

