/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.security.CronappUserDetails;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class ActiveDirectoryUserDetailsMapper
implements UserDetailsContextMapper {
    private static final Logger logger = Logger.getLogger(UserDetailsContextMapper.class.getName());
    private final String domain;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();

    public ActiveDirectoryUserDetailsMapper(String domain) {
        this.domain = domain;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        if (StringUtils.isNotEmpty((CharSequence)AppConfig.groupName())) {
            List<String> groups = Arrays.asList(AppConfig.groupName().split(","));
            if (authorities.stream().noneMatch(authority -> groups.stream().anyMatch(group -> ApiManager.normalize(authority.getAuthority()).equals(ApiManager.normalize(group))))) {
                throw new BadCredentialsException(this.messages.getMessage("LdapAuthenticationProvider.badCredentials", "Bad credentials"));
            }
        }
        Attributes attributes = ctx.getAttributes();
        String userName = ActiveDirectoryUserDetailsMapper.getAttributeString(attributes, "sAMAccountName");
        String normalizedUserName = ApiManager.normalize(userName);
        Object email = ActiveDirectoryUserDetailsMapper.getAttributeString(attributes, "mail");
        if (email == null) {
            email = normalizedUserName + "@" + this.domain;
        }
        String normalizedEmail = ApiManager.normalize((String)email);
        Set securables = authorities.stream().flatMap(authority -> ApiManager.getRoleSecurables(authority.getAuthority()).stream()).map(securable -> securable.getStringField("name")).collect(Collectors.toSet());
        securables.addAll(ApiManager.getUserSecurables(username).stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        securables.addAll(ApiManager.getAuthenticatedSecurables().stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        securables.addAll(ApiManager.getPublicSecurables().stream().map(securable -> securable.getStringField("name")).collect(Collectors.toList()));
        Set<GrantedAuthority> mappedAuthorities = securables.stream().distinct().sorted().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
        Map<String, Object> payload = Collections.list(attributes.getAll()).stream().collect(Collectors.toMap(Attribute::getID, this::getAttributeValue));
        return CronappUserDetails.newBuilder().setName(ActiveDirectoryUserDetailsMapper.getAttributeString(attributes, "displayName")).setUserName(userName).setNormalizedUserName(normalizedUserName).setEmail((String)email).setNormalizedEmail(normalizedEmail).setEmailConfirmed(true).setSecurityStamp(UUID.randomUUID().toString()).setPhoneNumber(ActiveDirectoryUserDetailsMapper.getAttributeString(attributes, "telephoneNumber")).setPhoneNumberConfirmed(true).setTwoFactorEnabled(false).setLockoutEnd(OffsetDateTime.MIN).setLockoutEnabled(false).setAccessFailedCount(0).setAuthorities(mappedAuthorities).setPayload(payload).build();
    }

    private Object getAttributeValue(Attribute attribute) {
        try {
            return attribute.get();
        }
        catch (NamingException e) {
            logger.log(Level.SEVERE, String.format("Error reading attribute %s", attribute.getID()), e);
            return null;
        }
    }

    private static String getAttributeString(Attributes attributes, String name) {
        Object rawAttribute = ActiveDirectoryUserDetailsMapper.getAttribute(attributes, name);
        if (rawAttribute == null) {
            return null;
        }
        return rawAttribute.toString();
    }

    private static Object getAttribute(Attributes attributes, String name) {
        try {
            Attribute attr = attributes.get(name);
            if (attr != null) {
                return attr.get();
            }
            return null;
        }
        catch (NamingException e) {
            logger.log(Level.SEVERE, String.format("Error reading attribute %s", name), e);
            return null;
        }
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
    }
}

