/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.scheduler;

import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.scheduler.SchedulerDataSourceInitializer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.quartz.JobStoreType;
import org.springframework.boot.autoconfigure.quartz.QuartzAutoConfiguration;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSource;
import org.springframework.boot.autoconfigure.quartz.QuartzDataSourceInitializer;
import org.springframework.boot.autoconfigure.quartz.QuartzProperties;
import org.springframework.boot.jdbc.DataSourceInitializationMode;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.scheduling.quartz.SpringBeanJobFactory;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SchedulerConfiguration
extends QuartzAutoConfiguration {
    private static final Log logger = LogFactory.getLog(SchedulerConfiguration.class);

    public SchedulerConfiguration(@Qualifier(value="cronappDataSource") DataSource dataSource, CronappSettingsService settings, QuartzProperties properties) throws SQLException {
        properties.setJobStoreType(JobStoreType.JDBC);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM QUARTZ_LOCKS");){
                properties.getJdbc().setInitializeSchema(DataSourceInitializationMode.NEVER);
            }
            catch (SQLException e) {
                properties.getJdbc().setInitializeSchema(DataSourceInitializationMode.ALWAYS);
            }
        }
        properties.getProperties().put("org.quartz.scheduler.instanceId", settings.getIntanceId());
        properties.getProperties().put("org.quartz.jobStore.isClustered", "true");
    }

    @Bean
    public QuartzDataSourceInitializer quartzDataSourceInitializer(@Qualifier(value="cronappDataSource") DataSource dataSource, ResourceLoader resourceLoader, QuartzProperties properties) {
        return new SchedulerDataSourceInitializer(dataSource, resourceLoader, properties);
    }

    @Bean
    public SchedulerFactoryBean globalScheduler(ObjectProvider<Trigger> triggers, ApplicationContext applicationContext, CronappSettingsService settings, QuartzProperties quartzProperties, @Qualifier(value="cronappDataSource") DataSource dataSource, @Qualifier(value="cronappTransactionManager") PlatformTransactionManager transactionManager) {
        String driverDelegateClass;
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        SpringBeanJobFactory jobFactory = new SpringBeanJobFactory();
        jobFactory.setApplicationContext(applicationContext);
        schedulerFactoryBean.setJobFactory((JobFactory)jobFactory);
        schedulerFactoryBean.setSchedulerName(settings.getApplicationId());
        schedulerFactoryBean.setWaitForJobsToCompleteOnShutdown(true);
        schedulerFactoryBean.setDataSource(dataSource);
        schedulerFactoryBean.setTransactionManager(transactionManager);
        schedulerFactoryBean.setTriggers((Trigger[])triggers.orderedStream().toArray(Trigger[]::new));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)quartzProperties.getProperties());
        try {
            String databaseProductName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
            String commonDatabaseName = JdbcUtils.commonDatabaseName((String)databaseProductName);
            DatabaseDriver databaseDriver = DatabaseDriver.fromProductName((String)commonDatabaseName);
            switch (databaseDriver) {
                case JTDS: 
                case SQLSERVER: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
                    break;
                }
                case HSQLDB: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.HSQLDBDelegate";
                    break;
                }
                case ORACLE: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.OracleDelegate";
                    break;
                }
                case POSTGRESQL: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
                    break;
                }
                case DB2: 
                case DB2_AS400: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.DB2v8Delegate";
                    break;
                }
                default: {
                    driverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
                    break;
                }
            }
        }
        catch (MetaDataAccessException e) {
            logger.error((Object)"Error detecting driver delegate class", (Throwable)e);
            driverDelegateClass = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
        }
        properties.put("org.quartz.jobStore.driverDelegateClass", driverDelegateClass);
        schedulerFactoryBean.setQuartzProperties(properties);
        return schedulerFactoryBean;
    }

    @QuartzDataSource
    public DataSource quartzDataSource(@Qualifier(value="cronappDataSource") DataSource dataSource) {
        return dataSource;
    }
}

