/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.templater;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.springframework.web.context.ServletContextAware;

public class TemplaterService
implements ServletContextAware {
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);
    private ServletContext servletContext;

    @PostConstruct
    public void populateContext() {
        this.configuration.setServletContextForTemplateLoading((Object)this.servletContext, "/WEB-INF/classes/templates");
    }

    public String process(String templateName, Map<String, Object> dataModel, Locale locale) throws IOException, TemplateException {
        Template template = this.configuration.getTemplate(templateName, locale);
        StringWriter writer = new StringWriter();
        template.process(dataModel, (Writer)writer);
        return writer.toString();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

