/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.service;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.AuthConfig;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OAuth2Lib;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.client.WebTargetFactory;
import br.com.techne.cronos.paas.util.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;

@Path(value="/userinfo")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserInfoService {
    private Logger logger = Logger.getLogger(UserInfoService.class);
    @Context
    private SecurityContext securityContext;

    @GET
    @Produces(value={"application/json"})
    public Response get() {
        this.logger.debug("Accessando /userinfo");
        try {
            String userinfo = "{}";
            if (OAuth2Lib.isAuthenticated((OidcUser)this.securityContext.getUserPrincipal())) {
                userinfo = this.getUAAUserInfo();
            }
            return Response.ok((Object)userinfo).build();
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception);
        }
    }

    private String getUAAUserInfo() {
        UriBuilder uriResourceServerBase = UriBuilder.fromUri((String)AuthConfig.UAA_ENDPOINT_BASE_URI);
        WebTargetFactory factory = WebTargetFactory.getInstance();
        WebTarget target = factory.getWebTarget(this.securityContext, uriResourceServerBase.path("userinfo").build(new Object[0]));
        return (String)target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String.class);
    }
}

