/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.util;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;

public class Logger {
    private static java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger("br.com.techne.cronos.paas.util.Logger");
    private Class<?> clazz;
    private DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public Logger(Class<?> clazz) {
        this.clazz = clazz;
    }

    private static void setupLogger() {
        try {
            LOGGER.setLevel(Level.ALL);
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error occur Logger setup.", exception);
        }
        LOGGER.config("Logger configuration done.");
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(clazz);
    }

    public void warn(String message, Throwable t) {
        LOGGER.log(Level.WARNING, message, t);
    }

    public void warn(String message) {
        LOGGER.warning(this.getParsedDate() + this.clazz.getName() + ":" + message);
    }

    public void error(String message) {
        LOGGER.severe(this.getParsedDate() + this.clazz.getName() + ":" + message);
    }

    public void error(Throwable t) {
        LOGGER.log(Level.SEVERE, t.getMessage(), t);
    }

    public void error(String message, Throwable t) {
        LOGGER.log(Level.SEVERE, message, t);
    }

    public void debug(String message) {
        LOGGER.fine(this.getParsedDate() + this.clazz.getName() + ":" + message);
    }

    public void debug(Throwable t) {
        LOGGER.log(Level.FINE, t.getMessage(), t);
    }

    public void debug(String message, Throwable t) {
        LOGGER.log(Level.FINE, message, t);
    }

    public void info(String message) {
        LOGGER.info(this.getParsedDate() + this.clazz.getName() + ":" + message);
    }

    public void info(Throwable t) {
        LOGGER.log(Level.INFO, t.getMessage(), t);
    }

    public void info(String message, Throwable t) {
        LOGGER.log(Level.INFO, message, t);
    }

    private String getParsedDate() {
        return LocalDateTime.now().format(this.formatter);
    }

    static {
        Logger.setupLogger();
    }
}

