/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.i18n;

import br.com.techne.cronos.paas.util.Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class MessageUtils {
    private static Logger logger = Logger.getLogger(MessageUtils.class);
    public static ThreadLocal<Object> threadLocal = new ThreadLocal();
    private static final Map<ResourceBundle, Object> map = new HashMap<ResourceBundle, Object>();

    public static String format(String pattern, Object ... arguments) {
        String fixedPattern = pattern.replace("'", "''");
        return MessageFormat.format(fixedPattern, arguments);
    }

    public static Object get(String bundleName, Class<?> clazz) {
        Object messages = threadLocal.get();
        if (messages == null) {
            messages = MessageUtils.getUTF8Encoded(bundleName, clazz);
        }
        return messages;
    }

    public static Object get(String bundleName, Class<?> clazz, Locale locale) {
        Object messages = threadLocal.get();
        if (messages == null) {
            messages = MessageUtils.getUTF8Encoded(bundleName, clazz, locale);
        }
        return messages;
    }

    public static Object getUTF8Encoded(String bundleName, Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), loader);
        return MessageUtils.internalGet(bundle, clazz);
    }

    public static Object getUTF8Encoded(String bundleName, Class<?> clazz, Locale locale) {
        ClassLoader loader = clazz.getClassLoader();
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, loader);
        return MessageUtils.internalGet(bundle, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object internalGet(ResourceBundle bundle, Class<?> clazz) {
        Object result;
        Map<ResourceBundle, Object> map = MessageUtils.map;
        synchronized (map) {
            result = MessageUtils.map.get(bundle);
            if (result == null) {
                try {
                    result = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                Field[] fields = clazz.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    String fieldName = fields[i].getName();
                    try {
                        if (!String.class.isAssignableFrom(fields[i].getType()) || !Modifier.isPublic(fields[i].getModifiers()) || Modifier.isStatic(fields[i].getModifiers())) continue;
                        try {
                            String value = bundle.getString(fieldName);
                            if (value == null) continue;
                            fields[i].setAccessible(true);
                            fields[i].set(result, value);
                            continue;
                        }
                        catch (Throwable mre) {
                            fields[i].setAccessible(true);
                            fields[i].set(result, "");
                            throw mre;
                        }
                    }
                    catch (Exception ex) {
                        String qualifiedName = clazz.getName() + "#" + fieldName;
                        logger.info("Falha ao carregar mensagem internacionalizada para: " + qualifiedName, ex);
                    }
                }
                MessageUtils.map.put(bundle, result);
            }
        }
        return result;
    }
}

