/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2;

import br.com.techne.cronos.paas.oidc.sdk.i18n.Messages;
import br.com.techne.cronos.paas.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class AuthConfig {
    public static String CLIENT_ID;
    public static String CALLBACK_URI;
    public static String AUTHORIZATION_URI;
    public static String CLIENT_SECRET;
    public static String TOKEN_URI;
    public static String USER_INFO_URI;
    public static String TOKEN_KEY_URI;
    public static String CHECK_TOKEN_URI;
    public static String SCOPE;
    public static String UAA_ENDPOINT_BASE_URI;
    public static String DEFAULT_REDIRECT_URI;
    public static String ALGORITHM_CERTIFICATE;
    private static Logger logger;

    public static void loadConfiguration(String resourceName) {
        try {
            InputStream resource = AuthConfig.class.getResourceAsStream("/" + resourceName + ".properties");
            if (resource != null) {
                Properties properties = new Properties();
                properties.load(resource);
                CLIENT_ID = properties.getProperty("CLIENT_ID");
                CLIENT_SECRET = properties.getProperty("CLIENT_SECRET");
                AUTHORIZATION_URI = properties.getProperty("AUTHORIZATION_URI");
                TOKEN_URI = properties.getProperty("TOKEN_URI");
                TOKEN_KEY_URI = properties.getProperty("TOKEN_KEY_URI");
                USER_INFO_URI = properties.getProperty("USER_INFO_URI");
                CHECK_TOKEN_URI = properties.getProperty("CHECK_TOKEN_URI");
                SCOPE = properties.getProperty("SCOPE");
                CALLBACK_URI = properties.getProperty("CALLBACK_URI");
                UAA_ENDPOINT_BASE_URI = properties.getProperty("UAA_ENDPOINT_BASE_URI");
                DEFAULT_REDIRECT_URI = properties.getProperty("DEFAULT_REDIRECT_URI");
                ALGORITHM_CERTIFICATE = properties.getProperty("ALGORITHM_CERTIFICATE", "RSA");
            }
        }
        catch (IOException e) {
            logger.error(e);
            throw new RuntimeException(Messages.get().ERROR_AUTH_CONFIG_LOAD, e);
        }
    }

    static {
        logger = Logger.getLogger(AuthConfig.class);
        AuthConfig.loadConfiguration("uaa");
    }
}

