/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2;

import br.com.techne.cronos.paas.oidc.sdk.i18n.Messages;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.AuthConfig;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import br.com.techne.cronos.paas.util.Logger;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.TokenRevocationRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCAccessTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.MissingFormatArgumentException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;

public class OAuth2Lib {
    public static final String OIDC_USER = "oidcUser";
    private static Logger logger = Logger.getLogger(OAuth2Lib.class);

    public static boolean isAuthenticated(HttpServletRequest request, HttpServletResponse response) {
        boolean authenticated = false;
        HttpSession session = request.getSession();
        Object attr = session.getAttribute(OIDC_USER);
        if (attr != null && attr instanceof OidcUser) {
            OidcUser user = (OidcUser)attr;
            authenticated = OAuth2Lib.isAuthenticated(user);
        }
        logger.debug(String.format("[isAuthenticated] : %s", authenticated));
        return authenticated;
    }

    public static boolean isAuthenticated(OidcUser user) {
        boolean authenticated = false;
        if (user != null && user.userId != null && user.accessToken != null) {
            JSONObject json = OAuth2Lib.checkToken(user.accessToken);
            logger.debug(String.format("[isAuthenticated] check_token: %s", json.toJSONString()));
            authenticated = user.userId.equals(json.get((Object)"user_id"));
        }
        return authenticated;
    }

    public static void signIn(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!OAuth2Lib.isAuthenticated(request, response)) {
            OidcUser user = new OidcUser();
            user.originalUrl = request.getRequestURL().toString();
            HttpSession session = request.getSession();
            session.setAttribute(OIDC_USER, (Object)user);
            response.sendRedirect(OAuth2Lib.composeAuthzRequestURL().toString());
        }
    }

    public static URL composeAuthzRequestURL() {
        URL authzURL;
        try {
            ResponseType rt = new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE});
            Scope scope = Scope.parse((String)AuthConfig.SCOPE);
            ClientID clientID = new ClientID(AuthConfig.CLIENT_ID);
            URL redirectURI = new URL(AuthConfig.CALLBACK_URI);
            State state = new State();
            Nonce nonce = new Nonce();
            AuthenticationRequest authRequest = new AuthenticationRequest(redirectURI.toURI(), rt, scope, clientID, redirectURI.toURI(), state, nonce);
            String queryString = authRequest.toQueryString();
            URL authzEndpointURL = new URL(AuthConfig.AUTHORIZATION_URI);
            authzURL = new URL(authzEndpointURL + "?" + queryString);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_COMPOSE_OICD_URL, e);
        }
        return authzURL;
    }

    public static AuthenticationSuccessResponse parseAuthenticationRequest(HttpServletRequest request) {
        return OAuth2Lib.parseAuthenticationRequest(request.getQueryString());
    }

    public static AuthenticationSuccessResponse parseAuthenticationRequest(String queryString) {
        AuthenticationResponse authResponse;
        if (queryString == null || queryString.trim().isEmpty()) {
            throw new RuntimeException(Messages.get().ERROR_MISSING_URL_QUERY_STRING);
        }
        try {
            authResponse = AuthenticationResponseParser.parse((URI)new URL(AuthConfig.AUTHORIZATION_URI + "?" + queryString).toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_PARSE_OIDC_RESPONSE, e);
        }
        if (authResponse instanceof AuthenticationErrorResponse) {
            AuthenticationErrorResponse authzError = (AuthenticationErrorResponse)authResponse;
            throw new RuntimeException(Messages.format(Messages.get().ERROR_AUTHZ_RESPONSE, authzError.getErrorObject()));
        }
        AuthenticationSuccessResponse authzSuccess = (AuthenticationSuccessResponse)authResponse;
        return authzSuccess;
    }

    public static TokenResponse getAccessToken(AuthorizationCode code) {
        TokenResponse tokenResponse;
        HTTPResponse httpResponse;
        HTTPRequest httpRequest;
        if (code == null) {
            throw new RuntimeException(Messages.get().ERROR_MISSING_AUTH_CODE);
        }
        ClientID clientID = new ClientID(AuthConfig.CLIENT_ID);
        Secret clientSecret = new Secret(AuthConfig.CLIENT_SECRET);
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
        Scope scope = new Scope();
        try {
            URL tokenEndpointURL = new URL(AuthConfig.TOKEN_URI);
            AuthorizationCodeGrant authCodeGrant = new AuthorizationCodeGrant(code, new URI(AuthConfig.CALLBACK_URI));
            TokenRequest accessTokenRequest = new TokenRequest(tokenEndpointURL.toURI(), (ClientAuthentication)clientAuth, (AuthorizationGrant)authCodeGrant, scope);
            httpRequest = accessTokenRequest.toHTTPRequest();
        }
        catch (SerializeException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_CREATE_TOKEN_REQUEST, e);
        }
        try {
            httpResponse = httpRequest.send();
        }
        catch (IOException e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_GET_TOKEN, e);
        }
        try {
            tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)httpResponse);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_PARSE_TOKEN_RESPONSE, e);
        }
        if (tokenResponse instanceof TokenErrorResponse) {
            TokenErrorResponse tokenError = (TokenErrorResponse)tokenResponse;
            throw new RuntimeException(Messages.format(Messages.get().ERROR_TOKEN_RESPONSE, tokenError.getErrorObject()));
        }
        return tokenResponse;
    }

    public static SignedJWT getSignedToken(TokenResponse tokenResponse) {
        OIDCAccessTokenResponse tokenSuccess = (OIDCAccessTokenResponse)tokenResponse;
        SignedJWT signedJWTToken = (SignedJWT)tokenSuccess.getIDToken();
        return signedJWTToken;
    }

    public static SignedJWT getSignedToken(AuthorizationCode code) {
        TokenResponse tokenResponse = OAuth2Lib.getAccessToken(code);
        return OAuth2Lib.getSignedToken(tokenResponse);
    }

    public static JSONObject getTokenKey(BearerAccessToken accessToken) {
        ClientID clientID = new ClientID(AuthConfig.CLIENT_ID);
        Secret clientSecret = new Secret(AuthConfig.CLIENT_SECRET);
        JSONObject jwt = null;
        try {
            URL tokenKeyEndpointURL = new URL(AuthConfig.TOKEN_KEY_URI);
            UserInfoRequest tokenKeyRequest = new UserInfoRequest(tokenKeyEndpointURL.toURI(), accessToken);
            HTTPRequest httpRequest = tokenKeyRequest.toHTTPRequest();
            ClientSecretBasic basic = new ClientSecretBasic(clientID, clientSecret);
            basic.applyTo(httpRequest);
            HTTPResponse httpResponse = httpRequest.send();
            jwt = httpResponse.getContentAsJSONObject();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_GET_TOKEN_KEY, e);
        }
        return jwt;
    }

    public static JSONObject checkToken(BearerAccessToken accessToken) {
        JSONObject json = null;
        try {
            ClientID clientID = new ClientID(AuthConfig.CLIENT_ID);
            Secret clientSecret = new Secret(AuthConfig.CLIENT_SECRET);
            ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
            URL checkTokenEndpointURL = new URL(AuthConfig.CHECK_TOKEN_URI);
            TokenRevocationRequest checkTokenRequest = new TokenRevocationRequest(checkTokenEndpointURL.toURI(), (ClientAuthentication)clientAuth, (Token)accessToken);
            HTTPRequest httpRequest = checkTokenRequest.toHTTPRequest();
            HTTPResponse httpResponse = httpRequest.send();
            json = httpResponse.getContentAsJSONObject();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_GET_TOKEN_KEY, e);
        }
        return json;
    }

    public static JSONObject getUserInfo(BearerAccessToken accessToken) {
        JSONObject userInfo = new JSONObject();
        try {
            URL userinfoEndpointURL = new URL(AuthConfig.USER_INFO_URI);
            UserInfoRequest userInfoRequest = new UserInfoRequest(userinfoEndpointURL.toURI(), accessToken);
            HTTPResponse httpResponse = userInfoRequest.toHTTPRequest().send();
            userInfo = httpResponse.getContentAsJSONObject();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_COULD_NOT_GET_USERINFO, e);
        }
        return userInfo;
    }

    public static boolean verifySignedToken(SignedJWT signedToken, JSONObject tokenKey) {
        boolean valid = false;
        if (signedToken != null) {
            switch (AuthConfig.ALGORITHM_CERTIFICATE) {
                case "RSA": {
                    RSAKey jwk = null;
                    try {
                        jwk = RSAKey.parse((String)tokenKey.toJSONString());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(Messages.get().ERROR_COULD_NOT_PROCESS_ID_TOKEN, e);
                    }
                    try {
                        RSASSAVerifier verifier = new RSASSAVerifier(jwk.toRSAPublicKey());
                        valid = signedToken.verify((JWSVerifier)verifier);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(Messages.get().ERROR_COULD_NOT_PROCESS_ID_TOKEN, e);
                    }
                }
                default: {
                    String tokenKeyValue = tokenKey.get((Object)"value").toString();
                    byte[] sharedSecret = new byte[512];
                    for (int i = 0; i < tokenKeyValue.length(); ++i) {
                        sharedSecret[i] = (byte)tokenKeyValue.charAt(i);
                    }
                    try {
                        MACVerifier verifier = new MACVerifier(sharedSecret);
                        valid = signedToken.verify((JWSVerifier)verifier);
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(Messages.get().ERROR_COULD_NOT_PROCESS_ID_TOKEN, e);
                    }
                }
            }
        }
        return valid;
    }

    public static boolean checkIfWebServletAnnotationExists(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.isAnnotationPresent(WebServlet.class)) {
            throw new MissingFormatArgumentException("You must note the class with @WebServlet");
        }
        return true;
    }

    public static AccessToken refreshToken(String accessTokenValue) {
        RefreshToken refreshToken = new RefreshToken(accessTokenValue);
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(refreshToken);
        ClientID clientID = new ClientID(AuthConfig.CLIENT_ID);
        Secret clientSecret = new Secret(AuthConfig.CLIENT_SECRET);
        ClientSecretBasic clientAuth = new ClientSecretBasic(clientID, clientSecret);
        try {
            URI tokenEndpoint = new URI(AuthConfig.TOKEN_URI);
            TokenRequest request = new TokenRequest(tokenEndpoint, (ClientAuthentication)clientAuth, (AuthorizationGrant)refreshTokenGrant);
            TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
            if (!response.indicatesSuccess()) {
                TokenErrorResponse tokenError = (TokenErrorResponse)response;
                throw new RuntimeException(Messages.format(Messages.get().ERROR_TOKEN_RESPONSE, tokenError.getErrorObject()));
            }
            AccessTokenResponse successResponse = (AccessTokenResponse)response;
            return successResponse.getAccessToken();
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.get().ERROR_PARSE_TOKEN_RESPONSE, e);
        }
    }
}

