/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.client;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.SecurityContext;

public class WebTargetFactory {
    private WebTargetFactory() {
    }

    public static WebTargetFactory getInstance() {
        return WebTargetFactoryHolder.instance;
    }

    public WebTarget getWebTarget(final SecurityContext securityContext, URI target) {
        Client client = ClientBuilder.newClient();
        if (securityContext != null && securityContext.getUserPrincipal() instanceof OidcUser) {
            client.register((Object)new ClientRequestFilter(){

                public void filter(ClientRequestContext requestContext) throws IOException {
                    requestContext.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.getAccessToken()));
                }

                private String getAccessToken() {
                    OidcUser user = (OidcUser)securityContext.getUserPrincipal();
                    return user == null ? "" : user.accessToken.getValue();
                }
            });
        }
        WebTarget webTarget = client.target(target);
        return webTarget;
    }

    private static class WebTargetFactoryHolder {
        private static WebTargetFactory instance = new WebTargetFactory();

        private WebTargetFactoryHolder() {
        }
    }
}

