/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.filter;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.AuthConfig;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OAuth2Lib;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.annotation.Secured;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.filter.OidcSecurityContext;
import br.com.techne.cronos.paas.util.Logger;
import br.com.techne.cronos.paas.util.Validator;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.OIDCAccessTokenResponse;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import net.minidev.json.JSONObject;

@Secured
@Provider
@Priority(value=1000)
public class OidcAuthenticationFilter
implements ContainerRequestFilter {
    private Logger logger = Logger.getLogger(OidcAuthenticationFilter.class);
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest httpServletRequest;
    @Context
    private HttpServletResponse httpServletResponse;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!this.isAuthenticated(requestContext)) {
            this.attemptAuthentication(requestContext);
            return;
        }
    }

    private boolean isAuthenticated(ContainerRequestContext requestContext) {
        SecurityContext securityContext = requestContext.getSecurityContext();
        return securityContext != null && securityContext instanceof OidcSecurityContext && OAuth2Lib.isAuthenticated((OidcUser)securityContext.getUserPrincipal());
    }

    private void attemptAuthentication(ContainerRequestContext requestContext) throws IOException {
        if (!Validator.isNullOrEmpty(this.httpServletRequest.getParameter("error"))) {
            this.logger.debug(String.format("Tratando request com erro: %s", this.httpServletRequest.getParameter("error")));
            this.handleError(requestContext);
        } else if (this.uriInfo.getPath().endsWith("oauth2/callback") && !Validator.isNullOrEmpty(this.httpServletRequest.getParameter("code"))) {
            this.logger.debug("Tratando \"Authorization Server\" response CODE para obten\u00e7\u00e3o de um ACCESS_TOKEN.");
            this.handleAuthorizationCodeResponse(requestContext);
        } else {
            this.logger.debug("Inicializando \"OpenID Connect Authorization Flow\".");
            this.handleAuthorizationRequest(requestContext);
        }
    }

    private void handleAuthorizationRequest(ContainerRequestContext requestContext) throws IOException {
        OidcUser user = new OidcUser();
        user.originalUrl = this.httpServletRequest.getRequestURL().toString();
        HttpSession session = this.httpServletRequest.getSession();
        session.setAttribute("oidcUser", (Object)user);
        try {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.SEE_OTHER).location(new URI(OAuth2Lib.composeAuthzRequestURL().toString())).build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleAuthorizationCodeResponse(ContainerRequestContext requestContext) throws IOException {
        HttpSession session = this.httpServletRequest.getSession();
        OidcUser user = (OidcUser)session.getAttribute("oidcUser");
        if (user == null) {
            user = new OidcUser();
            user.originalUrl = this.httpServletRequest.getRequestURL().toString();
        }
        if (user.userId == null || user.userId.length() == 0) {
            JSONObject userInfo;
            AuthenticationSuccessResponse authzSuccess = OAuth2Lib.parseAuthenticationRequest(this.httpServletRequest);
            AuthorizationCode code = authzSuccess.getAuthorizationCode();
            TokenResponse tokenResponse = OAuth2Lib.getAccessToken(code);
            OIDCAccessTokenResponse tokenSuccess = (OIDCAccessTokenResponse)tokenResponse;
            BearerAccessToken accessToken = (BearerAccessToken)tokenSuccess.getAccessToken();
            RefreshToken refreshToken = tokenSuccess.getRefreshToken();
            JWT idToken = tokenSuccess.getIDToken();
            SignedJWT signedJWTToken = OAuth2Lib.getSignedToken(tokenResponse);
            JSONObject tokenKey = OAuth2Lib.getTokenKey(accessToken);
            if (signedJWTToken != null && !OAuth2Lib.verifySignedToken(signedJWTToken, tokenKey)) {
                this.httpServletResponse.sendError(403, "Invalid Id Token signature");
                return;
            }
            user.userInfo = userInfo = OAuth2Lib.getUserInfo(accessToken);
            user.userId = userInfo.get((Object)"user_id").toString();
            user.userName = userInfo.get((Object)"user_name").toString();
            user.name = userInfo.get((Object)"name") != null ? userInfo.get((Object)"name").toString() : "";
            user.givenName = userInfo.get((Object)"given_name") != null ? userInfo.get((Object)"given_name").toString() : "";
            user.familyName = userInfo.get((Object)"family_name") != null ? userInfo.get((Object)"family_name").toString() : "";
            user.accessToken = accessToken;
            user.refreshToken = refreshToken;
            user.idToken = idToken;
            requestContext.setSecurityContext((SecurityContext)new OidcSecurityContext(user));
            session.setAttribute("oidcUser", (Object)user);
        }
        try {
            String redirectURI = !Validator.isNullOrEmpty(AuthConfig.DEFAULT_REDIRECT_URI) ? AuthConfig.DEFAULT_REDIRECT_URI : user.originalUrl;
            requestContext.abortWith(Response.status((Response.Status)Response.Status.SEE_OTHER).location(new URI(redirectURI)).build());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void handleError(ContainerRequestContext requestContext) {
        String error = this.httpServletRequest.getParameter("error");
        String errorDescription = this.httpServletRequest.getParameter("error_description");
        String errorURI = this.httpServletRequest.getParameter("error_uri");
        requestContext.abortWith(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Authorization Endpoint Error: %s - %s - %s", error, errorDescription, errorURI)).build());
    }
}

