/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.filter;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.OAuth2Lib;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.filter.OidcSecurityContext;
import br.com.techne.cronos.paas.util.Logger;
import java.io.IOException;
import javax.annotation.Priority;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
@Priority(value=1000)
public class PreMatchingAuthenticationFilter
implements ContainerRequestFilter {
    private Logger logger = Logger.getLogger(PreMatchingAuthenticationFilter.class);
    @Context
    private HttpServletRequest httpServletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.logger.debug("[PreMatching Authentication Filter]");
        OidcUser oidcUser = (OidcUser)this.httpServletRequest.getSession().getAttribute("oidcUser");
        if (OAuth2Lib.isAuthenticated(oidcUser)) {
            requestContext.setSecurityContext((SecurityContext)new OidcSecurityContext(oidcUser));
        }
    }
}

