/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.service;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.AuthConfig;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.annotation.Secured;
import br.com.techne.cronos.paas.util.Logger;
import br.com.techne.cronos.paas.util.Validator;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AuthService {
    private Logger logger = Logger.getLogger(AuthService.class);
    @Context
    private HttpServletRequest httpServletRequest;

    @GET
    @Path(value="login")
    @Produces(value={"application/json"})
    @Secured
    public Response doLogin() throws URISyntaxException {
        if (!Validator.isNullOrEmpty(AuthConfig.DEFAULT_REDIRECT_URI)) {
            return Response.status((Response.Status)Response.Status.SEE_OTHER).location(new URI(AuthConfig.DEFAULT_REDIRECT_URI)).build();
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="oauth2/callback")
    @Produces(value={"application/json"})
    @Secured
    public Response doOAuthCodeCallback() {
        return Response.ok().build();
    }

    @GET
    @Path(value="logout")
    @Produces(value={"application/json"})
    public Response doLogout() {
        this.logger.debug("Cleaning up Relying Party session.");
        try {
            HttpSession httpSession = this.httpServletRequest.getSession();
            if (httpSession != null) {
                httpSession.setAttribute("oidcUser", null);
                httpSession.invalidate();
            }
            return Response.ok().build();
        }
        catch (Exception exception) {
            throw new WebApplicationException((Throwable)exception);
        }
    }
}

