/*
 * Decompiled with CFR 0.152.
 */
package br.com.techne.cronos.paas.oidc.sdk.oauth2.servlet;

import br.com.techne.cronos.paas.oidc.sdk.oauth2.OAuth2Lib;
import br.com.techne.cronos.paas.oidc.sdk.oauth2.OidcUser;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.OIDCAccessTokenResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONObject;

public class OidcCallbackServlet
extends HttpServlet {
    private static final long serialVersionUID = -696840155622416565L;

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession();
        OidcUser user = (OidcUser)session.getAttribute("oidcUser");
        if (user.userId == null || user.userId.length() == 0) {
            JSONObject userInfo;
            AuthenticationSuccessResponse authzSuccess = OAuth2Lib.parseAuthenticationRequest(req);
            AuthorizationCode code = authzSuccess.getAuthorizationCode();
            TokenResponse tokenResponse = OAuth2Lib.getAccessToken(code);
            OIDCAccessTokenResponse tokenSuccess = (OIDCAccessTokenResponse)tokenResponse;
            BearerAccessToken accessToken = (BearerAccessToken)tokenSuccess.getAccessToken();
            RefreshToken refreshToken = tokenSuccess.getRefreshToken();
            JWT idToken = tokenSuccess.getIDToken();
            SignedJWT signedJWTToken = OAuth2Lib.getSignedToken(tokenResponse);
            JSONObject tokenKey = OAuth2Lib.getTokenKey(accessToken);
            if (signedJWTToken != null && !OAuth2Lib.verifySignedToken(signedJWTToken, tokenKey)) {
                resp.sendError(403, "Invalid Id Token signature");
                return;
            }
            user.userInfo = userInfo = OAuth2Lib.getUserInfo(accessToken);
            user.userId = userInfo.get((Object)"user_id").toString();
            user.userName = userInfo.get((Object)"user_name").toString();
            user.name = userInfo.get((Object)"name") != null ? userInfo.get((Object)"name").toString() : "";
            user.givenName = userInfo.get((Object)"given_name") != null ? userInfo.get((Object)"given_name").toString() : "";
            user.familyName = userInfo.get((Object)"family_name") != null ? userInfo.get((Object)"family_name").toString() : "";
            user.accessToken = accessToken;
            user.refreshToken = refreshToken;
            user.idToken = idToken;
            session.setAttribute("oidcUser", (Object)user);
            resp.sendRedirect(user.originalUrl);
        } else {
            resp.sendRedirect(user.originalUrl);
        }
    }
}

