/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.openapi.codegen;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import cronapp.framework.openapi.codegen.DynamicEngineAdapter;
import freemarker.template.TemplateMethodModelEx;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.languages.JavaClientCodegen;
import org.openapitools.codegen.model.ApiInfoMap;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronapiJavaCodegen
extends JavaClientCodegen {
    public static final String BLOCK_PACKAGE = "blockPackage";
    public static final String BLOCK_PACKAGE_DESC = "package for generated blocks";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String NEW_API_CLIENT_NAME = "newApiClientName";
    private static final Logger LOGGER = LoggerFactory.getLogger(CronapiJavaCodegen.class);
    private String specId;
    private String blockPackage;
    private String operationCategory;
    private boolean operationCategoryTags;
    private TemplatingEngineAdapter templatingEngineAdapter = new DynamicEngineAdapter();

    public CronapiJavaCodegen() {
        this.invokerPackage = "cronapp.openapi.client";
        this.apiPackage = "cronapp.openapi.client.api";
        this.blockPackage = "cronapp.openapi.client.block";
        this.modelPackage = "cronapp.openapi.client.model";
        this.openApiNullable = false;
        this.cliOptions.add(CliOption.newString((String)BLOCK_PACKAGE, (String)BLOCK_PACKAGE_DESC));
        this.apiTemplateFiles.put("Block.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelTestTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
    }

    private static String createUUID(String value) {
        byte[] hashBytes = DigestUtils.md5((String)value.toLowerCase());
        BigInteger hashBigInt = new BigInteger(1, hashBytes);
        long mostSigBits = hashBigInt.longValue();
        long leastSigBits = hashBigInt.shiftRight(64).longValue();
        return "q" + new UUID(mostSigBits, leastSigBits).toString().replace("-", "");
    }

    private static String lookupUUID(String ref, String specId, OpenAPI openAPI) {
        for (Map.Entry pathEntry : openAPI.getPaths().entrySet()) {
            Operation get = ((PathItem)pathEntry.getValue()).getGet();
            if (get == null) continue;
            for (ApiResponse response : get.getResponses().values()) {
                String dResultsItemsRef;
                Schema dResultsItems;
                Schema dResults;
                Schema dProperty;
                Schema schema;
                MediaType responseJson;
                Content responseContent = response.getContent();
                if (responseContent == null || (responseJson = (MediaType)responseContent.get((Object)"application/json")) == null || (schema = CronapiJavaCodegen.resolveSchema(openAPI, responseJson.getSchema())) == null || schema.getType() == null || !schema.getType().equals("object") || schema.getProperties() == null || (dProperty = CronapiJavaCodegen.resolveSchema(openAPI, schema.getProperties().get("d"))) == null || (dResults = CronapiJavaCodegen.resolveSchema(openAPI, dProperty.getProperties().get("results"))) == null || (dResultsItems = dResults.getItems()) == null || (dResultsItemsRef = dResultsItems.get$ref()) == null || !dResultsItemsRef.equals(ref)) continue;
                if (get.getOperationId() == null) {
                    LOGGER.warn("OperationId not found for path: {}", pathEntry.getKey());
                    continue;
                }
                return CronapiJavaCodegen.createUUID(specId + get.getOperationId());
            }
        }
        LOGGER.warn("UUID not found for ref: {}", (Object)ref);
        return "notfound";
    }

    private static Schema resolveSchema(OpenAPI openAPI, Object candidate) {
        if (candidate == null) {
            return null;
        }
        if (!(candidate instanceof Schema)) {
            return null;
        }
        Schema schema = (Schema)candidate;
        String ref = schema.get$ref();
        if (ref != null) {
            return (Schema)openAPI.getComponents().getSchemas().get(ref.substring(21));
        }
        return schema;
    }

    public void processTemplateModels() {
        TemplateMethodModelEx createUUID = args -> CronapiJavaCodegen.createUUID(args.get(0).toString());
        TemplateMethodModelEx lookupUUID = args -> CronapiJavaCodegen.lookupUUID(args.get(0).toString(), this.specId, this.openAPI);
        this.additionalProperties.put("createUUID", createUUID);
        this.additionalProperties.put("lookupUUID", lookupUUID);
    }

    public void processOpts() {
        this.additionalProperties.put("enablePostProcessFile", true);
        super.processOpts();
        if (this.additionalProperties.containsKey(BLOCK_PACKAGE)) {
            this.blockPackage = this.additionalProperties.get(BLOCK_PACKAGE).toString();
        }
        this.specId = FilenameUtils.getBaseName((String)this.inputSpec);
        this.additionalProperties.put("specId", this.specId);
        this.additionalProperties.put("removeTypeArguments", new RemoveTypeArgumentsLambda());
        String blocksFolder = this.sourceFolder + File.separator + this.blockPackage.replace('.', File.separatorChar);
        String dataSourceFolder = this.projectFolder + File.separator + "resources/META-INF/datasources";
        this.supportingFiles.add(new SupportingFile("ApiClientBlocks.mustache", blocksFolder, "ApiClientBlocks.java"));
        this.supportingFiles.add(new SupportingFile("datasource.json.ftl", dataSourceFolder, this.specId + ".datasource.json"));
        Object operationCategoryObject = this.openAPI.getExtensions().get("x-cronapp-operation-category");
        this.operationCategory = operationCategoryObject == null ? null : operationCategoryObject.toString();
        Object operationCategoryTagsObject = this.openAPI.getExtensions().get("x-cronapp-operation-category-tags");
        boolean bl = this.operationCategoryTags = operationCategoryTagsObject != null && BooleanUtils.toBoolean((String)operationCategoryTagsObject.toString());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.operationCategory)) {
            this.operationCategory = this.openAPI.getInfo().getTitle();
        }
        this.additionalProperties.put("operationCategory", this.operationCategory);
        this.additionalProperties.put("operationCategoryTags", this.operationCategoryTags);
        this.processTemplateModels();
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            objs.put((Object)"blocksClassName", (Object)operations.getClassname().replaceAll(this.apiNameSuffix + "$", "Blocks"));
            String tagName = operations.getClassname().replaceAll(this.apiNameSuffix + "$", "");
            if (this.operationCategoryTags) {
                String tagDescription = this.openAPI.getTags().stream().map(Tag::getName).filter(name -> this.sanitizeTag((String)name).equals(tagName)).findFirst().orElse(tagName);
                objs.put((Object)CATEGORY_NAME, (Object)String.format("%s - %s", this.operationCategory, tagDescription));
            } else {
                objs.put((Object)CATEGORY_NAME, (Object)String.format(this.operationCategory, new Object[0]));
            }
            for (CodegenOperation operation : operations.getOperation()) {
                Object operationType = operation.vendorExtensions.get("x-cronapp-operation-type");
                if (operationType == null) continue;
                switch (operationType.toString()) {
                    case "BLOCKLY": {
                        operation.vendorExtensions.put("x-cronapp-operation-is-block", true);
                        break;
                    }
                    case "DATASOURCE": {
                        operation.vendorExtensions.put("x-cronapp-operation-is-datasource", true);
                        break;
                    }
                    case "ALL": {
                        operation.vendorExtensions.put("x-cronapp-operation-is-block", true);
                        operation.vendorExtensions.put("x-cronapp-operation-is-datasource", true);
                        break;
                    }
                }
                this.openAPI.getExtensions().forEach((key, value) -> operation.vendorExtensions.putIfAbsent(key, value));
            }
        }
        return objs;
    }

    public String apiFilename(String templateName, String tag) {
        if (templateName.equals("Block.mustache")) {
            return this.blockFileFolder() + File.separator + StringUtils.camelize((String)(tag + "_blocks")) + ".java";
        }
        return super.apiFilename(templateName, tag);
    }

    public String blockFileFolder() {
        return (this.outputFolder + File.separator + this.sourceFolder + File.separator + this.blockPackage.replace('.', File.separatorChar)).replace('/', File.separatorChar);
    }

    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        if (this.operationCategoryTags) {
            objs.put(CATEGORY_NAME, this.operationCategory);
            objs.put(NEW_API_CLIENT_NAME, String.format("%s - Nova Conex\u00e3o", this.operationCategory));
        } else {
            objs.put(CATEGORY_NAME, this.operationCategory);
            objs.put(NEW_API_CLIENT_NAME, "Nova Conex\u00e3o");
        }
        List modelMapList = (List)objs.get("models");
        objs.put("codegenModels", modelMapList.stream().map(ModelMap::getModel).collect(Collectors.toMap(model -> model.classname, model -> model)));
        ApiInfoMap apiInfo = (ApiInfoMap)objs.get("apiInfo");
        objs.put("codegenOperations", apiInfo.getApis().stream().map(OperationsMap::getOperations).flatMap(operations -> operations.getOperation().stream()).collect(Collectors.toList()));
        return super.postProcessSupportingFileData(objs);
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        return super.fromOperation(path, httpMethod, operation, servers);
    }

    public TemplatingEngineAdapter getTemplatingEngine() {
        return this.templatingEngineAdapter;
    }

    public void postProcessFile(File file, String fileType) {
        super.postProcessFile(file, fileType);
        if ("json".equals(FilenameUtils.getExtension((String)file.toString()))) {
            try {
                JsonNode jsonNode;
                Path path = file.toPath();
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    jsonNode = new ObjectMapper().reader().with((FormatFeature)JsonReadFeature.ALLOW_TRAILING_COMMA).readTree((Reader)reader);
                }
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)writer, (Object)jsonNode);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class RemoveTypeArgumentsLambda
    implements Mustache.Lambda {
        private RemoveTypeArgumentsLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replaceAll("<[^>]++>", ""));
        }
    }
}

