<#-- @ftlvariable name="specId" type="java.lang.String" -->
<#-- @ftlvariable name="createUUID" type="freemarker.template.TemplateMethodModelEx" -->
<#-- @ftlvariable name="lookupUUID" type="freemarker.template.TemplateMethodModelEx" -->
<#-- @ftlvariable name="openAPI" type="io.swagger.v3.oas.models.OpenAPI" -->
<#-- @ftlvariable name="apiInfo" type="org.openapitools.codegen.model.ApiInfoMap" -->
<#-- @ftlvariable name="models" type="java.util.List<org.openapitools.codegen.model.ModelMap>" -->
<#-- @ftlvariable name="responseDataType" type="org.openapitools.codegen.CodegenModel" -->
<#-- @ftlvariable name="dataVarss" type="java.util.List<org.openapitools.codegen.CodegenProperty>" -->
<#-- @ftlvariable name="codegenModels" type="java.util.Map<java.lang.String, org.openapitools.codegen.CodegenModel>" -->
<#-- @ftlvariable name="codegenOperations" type="java.util.List<org.openapitools.codegen.CodegenOperation>" -->
[
<#assign baseUrl = openAPI.getExtensions()['x-cronapp-base-url']!"" >
<#list codegenOperations as codegenOperation>
    <#assign extensions = openAPI.getExtensions()>
    <#assign categoryName = extensions['x-cronapp-operation-category']!"OpenAPI" >
    <#assign useTags = extensions['x-cronapp-operation-category-tags']!true>

    <#if codegenOperation.httpMethod == "GET">
        <#assign dataPath = "">
        <#assign dataVars = []>
        <#assign totalPath = "">

        <#assign operationExtensions = codegenOperation.vendorExtensions>
        <#if (operationExtensions['x-cronapp-operation-type']!"") == "DATASOURCE" || (operationExtensions['x-cronapp-operation-type']!"") == "ALL">
            <#assign operationUUID = createUUID(specId + codegenOperation.operationId)>

            <#if codegenOperation.tags?size != 0>
                <#assign operationTag = codegenOperation.tags[0].getName()>
            </#if>

            <#if codegenOperation.summary?has_content>
                <#assign operationName = codegenOperation.summary>
            <#elseif codegenOperation.operationId?has_content>
                <#assign operationName = codegenOperation.operationId>
            <#else>
                <#assign operationName = codegenOperation + "_"+ codegenOperation.operationId>
            </#if>

            <#list codegenOperation.responses as response>
                <#if response.is2xx>
                    <#if (operationExtensions['x-cronapp-operation-target']!"") == "DATASOURCE" && (codegenModels[operationTag+'Model']?has_content)>
                        <#assign dataPath = "\\\"$.d.results\\\"">
                        <#assign dataVars = codegenModels[operationTag+'Model'].vars>
                        <#assign dataModel = codegenModels[operationTag+'Model']>
                    <#elseif response.isArray && (codegenModels[response.baseType]?has_content)>
                        <#assign dataPath = "\\\"$\\\"">
                        <#assign dataVars = codegenModels[response.baseType].vars>
                    <#elseif response.dataType??>
                        <#if codegenModels[response.dataType]?has_content>
                            <#assign responseDataType = codegenModels[response.dataType] />

                            <#list responseDataType.vars as responseDataTypeVar>
                                <#if responseDataTypeVar.name == "results">
                                    <#assign dataPath = "\\\"$." + responseDataTypeVar.name + "\\\"">
                                    <#if responseDataTypeVar.isArray && codegenModels[responseDataTypeVar.complexType]?has_content>
                                        <#assign dataVars = codegenModels[responseDataTypeVar.complexType].vars>
                                    </#if>
                                </#if>
                                <#if responseDataTypeVar.name == "totalElements">
                                    <#assign totalPath = "\\\"$." + responseDataTypeVar.name + "\\\"">
                                </#if>
                            </#list>
                        </#if>
                    </#if>
                </#if>
            </#list>

            <#if dataPath?has_content && dataVars?has_content>
                <#assign endpoint = baseUrl + codegenOperation.path>
                <#if codegenOperation.hasQueryParams && (operationExtensions['x-cronapp-operation-target']!"") != "DATASOURCE">
                    <#assign endpoint = endpoint + "?">
                    <#list codegenOperation.queryParams as queryParam>
                        <#if queryParam.isQueryParam>
                            <#assign endpoint = endpoint + queryParam.paramName + "={" + queryParam.paramName + "}">
                            <#if !queryParam?is_last>
                                <#assign endpoint = endpoint + "&">
                            </#if>
                        </#if>
                    </#list>
                </#if>
 {
   "generated": true,
   "specId": "${specId}",
   "customId": "${operationUUID}",
   "serviceUrl": "api/cronapi/odata/v2/app/${operationUUID}/",
   <#if useTags && operationTag?has_content>
   "queryName": "${categoryName} - ${operationTag} - ${operationName}",
   <#else>
   "queryName": "${categoryName} - ${operationName}",
   </#if>
   "sourceType": "rest",
   "baseEntity": null,
   "blockly": null,
   "entitySimpleName": null,
   "entityFullName": null,
   "endpoint": {
     "url": "${endpoint}",
     "GET": {
       "parameters": {
         "$datapath": "${dataPath}"
       }
     },
     "POST": {},
     "PUT": {},
     "DELETE": {},
     "FILTER": {
       "parameters": {
         "$datapath": "${dataPath}"
       }
     },
     "COUNT": {
       <#if totalPath?has_content>
       "parameters": {
         "$datapath": "${totalPath}"
       }
       </#if>
     },
     "metadata": null
   },
   "query": "",
   "queryParamsValues": [
     <#if (operationExtensions['x-cronapp-operation-target']!"") != "DATASOURCE">
         <#list codegenOperation.queryParams as queryParam>
            <#if queryParam.isQueryParam>
            {
              "fieldName": "${queryParam.paramName}",
              "fieldValue": null
            }<#sep>,</#sep>
            </#if>
         </#list>
     </#if>
   ],
   "verbs": {
     "GET": ${(operationExtensions['x-cronapp-operation-verbs']!['GET'])?seq_contains("GET")?string("true", "false")},
     "GETAuthorities": null,
     "POST": ${(operationExtensions['x-cronapp-operation-verbs']![])?seq_contains("POST")?string("true", "false")},
     "POSTAuthorities": null,
     "PUT": ${(operationExtensions['x-cronapp-operation-verbs']![])?seq_contains("PUT")?string("true", "false")},
     "PUTAuthorities": null,
     "DELETE": ${(operationExtensions['x-cronapp-operation-verbs']![])?seq_contains("DELETE")?string("true", "false")},
     "DELETEAuthorities": null,
     "FILTER": ${(operationExtensions['x-cronapp-operation-verbs']!['GET'])?seq_contains("GET")?string("true", "false")},
     "FILTERAuthorities": null,
     "COUNT": ${(operationExtensions['x-cronapp-operation-verbs']!['GET'])?seq_contains("GET")?string("true", "false")},
     "COUNTAuthorities": null
   },
   "events": {
     "beforeInsert": null,
     "beforeUpdate": null,
     "beforeDelete": null,
     "afterInsert": null,
     "afterUpdate": null,
     "afterDelete": null,
     "onNavigate": null,
     "onAuthorize": null,
     "onError": null
   },
   "defaultValues": {
    <#list dataVars as dataVar>
        "${dataVar.name}": null,
    </#list>
   },
   "defaultValuesProperties": {
     <#list dataVars as dataVar>
         <#assign dataVarExtensions = dataVar.vendorExtensions>
        "${dataVar.name}": {
          "key": ${(dataVarExtensions['x-cronapp-primary-key']!false)?string},
          "nullable": ${(dataVarExtensions['x-cronapp-nullable']!true)?string},
         <#if dataVar.datatype == "OffsetDateTime">
          "type": "DateTimeOffset",
         <#elseif dataVar.datatype == "Integer">
          "type": "Int32",
         <#elseif dataVar.datatype == "UUID">
          "type": "Guid",
         <#elseif dataVar.datatype == "BigDecimal">
          "type": "Int64",
         <#elseif dataVar.datatype == "LocalDate">
          "type": "String",
         <#else>
          "type": "String",
         </#if>
          "updatable": true,
         <#if dataVarExtensions['x-cronapp-label']?has_content>
          "label": "${dataVarExtensions['x-cronapp-label']}",
         </#if>
         <#if dataVarExtensions['x-cronapp-length']?has_content>
          "dbLength": "${dataVarExtensions['x-cronapp-length']}",
         </#if>
         <#if dataVarExtensions['x-cronapp-precision']?has_content>
          "dbPrecision": "${dataVarExtensions['x-cronapp-precision']}",
         </#if>
         <#if dataVarExtensions['x-cronapp-scale']?has_content>
          "dbScale": "${dataVarExtensions['x-cronapp-scale']}",
         </#if>
         <#if dataVarExtensions['x-cronapp-mask']?has_content>
          "mask": "${dataVarExtensions['x-cronapp-mask']}",
         </#if>
         <#if dataVarExtensions['x-cronapp-attribute-type']?has_content>
          "attributeType": "${dataVarExtensions['x-cronapp-attribute-type']}",
         </#if>
         <#if (dataVarExtensions['x-cronapp-searchable']!false)??>
          "searchable": "${(dataVarExtensions['x-cronapp-searchable']!false)?string}",
         </#if>
         <#if dataVarExtensions['x-cronapp-ref']?has_content>
          "ref": "${lookupUUID(dataVarExtensions['x-cronapp-ref'])}",
         </#if>
          "autogenerated": ${(dataVarExtensions['x-cronapp-auto-generated']!false)?string}
        },
     </#list>
   },
   "security": {
     <#list dataVars as dataVar>
        "${dataVar.name}": null,
     </#list>
   },
   "calcFields": {},
   "calcFieldsSecurity": {},
   "calcFieldsProperties": {},
   "headers": {
     "Accept": "\"application/json\"",
     "Content-Type": "\"application/json\""
   },
   "errorHandles": {
     "primaryKey": null,
     "foreignKey": null
   },
   "audit": false,
   "swagger": false,
    <#if dataModel??>
        <#assign dataModelExtensions = dataModel.vendorExtensions>
        <#if dataModelExtensions['x-cronapp-table-role']?has_content>
   "role": "${dataModelExtensions['x-cronapp-table-role']}",
        </#if>
    </#if>
   "library": false
 }<#sep>,</#sep>
            </#if>
        </#if>
    </#if>
</#list>
]