/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c;

import cronapp.reports.j4c.commons.J4CBorderWidth;
import java.awt.Color;
import java.io.Serializable;
import java.util.stream.Stream;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;

public class J4CBorder
implements Serializable,
Cloneable {
    private LineStyleEnum lineStyle;
    private J4CBorderWidth width;
    private Color color;

    public J4CBorder() {
        this.lineStyle = LineStyleEnum.SOLID;
        this.width = J4CBorderWidth.NONE;
        this.color = Color.BLACK;
    }

    public J4CBorder(JRPen jrPen) {
        this.lineStyle = jrPen.getLineStyleValue();
        this.width = J4CBorderWidth.getByWidth(jrPen.getLineWidth().floatValue());
        this.color = jrPen.getLineColor();
    }

    public LineStyleEnum getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(LineStyleEnum lineStyle) {
        this.lineStyle = lineStyle;
    }

    public J4CBorderWidth getWidth() {
        return this.width;
    }

    public void setWidth(J4CBorderWidth width) {
        this.width = width;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CBorder j4CBorder = (J4CBorder)o;
        if (this.lineStyle != j4CBorder.lineStyle) {
            return false;
        }
        if (this.width != j4CBorder.width) {
            return false;
        }
        return this.color != null ? this.color.equals(j4CBorder.color) : j4CBorder.color == null;
    }

    public int hashCode() {
        int result = this.lineStyle != null ? this.lineStyle.hashCode() : 0;
        result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "J4CBorder{lineStyle=" + this.lineStyle + ", width=" + (Object)((Object)this.width) + ", color=" + this.color + '}';
    }

    public J4CBorder clone() {
        try {
            return (J4CBorder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static String[] lineStyles() {
        return (String[])Stream.of(LineStyleEnum.values()).map(LineStyleEnum::getName).toArray(String[]::new);
    }

    public void buildPen(JRPen pen) {
        if (pen != null) {
            pen.setLineColor(this.getColor());
            pen.setLineStyle(this.getLineStyle());
            pen.setLineWidth(this.getWidth().getWidth());
        }
    }
}

