/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports;

import cronapp.reports.ReportExport;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCompile {
    private static final Logger log = LoggerFactory.getLogger(PrintCompile.class);
    private final InputStream inputStream;
    private final String fileTarget;
    private Map<String, Object> parameters;

    PrintCompile(InputStream inputStream, String fileTarget) {
        this.inputStream = inputStream;
        this.fileTarget = fileTarget;
    }

    public PrintCompile setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public ReportExport print(Connection connection) {
        JasperPrint jasperPrint;
        try {
            jasperPrint = JasperFillManager.fillReport((InputStream)this.inputStream, this.parameters, (Connection)connection);
        }
        catch (JRException e) {
            log.error("Problems during the compile.");
            throw new RuntimeException(e);
        }
        return new ReportExport(this.fileTarget, jasperPrint);
    }

    public ReportExport print(Collection<Object> objectCollection) {
        JasperPrint jasperPrint;
        try {
            JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(objectCollection);
            jasperPrint = JasperFillManager.fillReport((InputStream)this.inputStream, this.parameters, (JRDataSource)dataSource);
        }
        catch (JRException e) {
            log.error("Problems during the compile.");
            throw new RuntimeException(e);
        }
        return new ReportExport(this.fileTarget, jasperPrint);
    }
}

