/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset;

import cronapp.reports.commons.AutoObserver;
import cronapp.reports.commons.Functions;
import cronapp.reports.j4c.dataset.J4CColumn;
import cronapp.reports.j4c.dataset.J4CTable;
import cronapp.reports.j4c.dataset.jdbc.Column;
import cronapp.reports.j4c.dataset.jdbc.ForeignKey;
import cronapp.reports.j4c.dataset.jdbc.JDBC;
import cronapp.reports.j4c.dataset.jdbc.PrimaryKey;
import cronapp.reports.j4c.dataset.jdbc.Relation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class J4CSQLBuilder {
    private final Connection connection;
    private AutoObserver<String> autoObserver;

    J4CSQLBuilder(Connection connection) {
        this.connection = connection;
    }

    J4CSQLBuilder(Connection connection, AutoObserver<String> autoObserver) {
        this.connection = connection;
        this.autoObserver = autoObserver;
    }

    public List<J4CTable> listTables() {
        return this.listTables(null);
    }

    public List<J4CTable> listTables(String schema) {
        ArrayList<J4CTable> tables = new ArrayList<J4CTable>();
        try {
            String[] types = new String[]{"TABLE"};
            DatabaseMetaData metaData = this.connection.getMetaData();
            ResultSet rs = metaData.getTables(null, schema, null, types);
            while (rs.next()) {
                String tableName = rs.getString(3);
                if (this.autoObserver != null) {
                    this.autoObserver.setValue(tableName);
                }
                tables.add(new J4CTable(tableName));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return tables.stream().sorted().collect(Collectors.toList());
    }

    public J4CTable populateTable(J4CTable table) throws SQLException {
        String tableName = table.getName();
        if (Functions.isExists(tableName)) {
            Map<String, Relation> fetchColumns = JDBC.fetchColumns(this.connection, null, tableName);
            fetchColumns.forEach((key, relation) -> {
                Collection<Column> columns = relation.getColumns().values();
                List<J4CColumn> j4CColumns = columns.stream().sorted((o1, o2) -> Integer.compare(o2.getOrdinalPosition(), o1.getOrdinalPosition())).map(column -> new J4CColumn(table, column.getName(), column.getType())).collect(Collectors.toList());
                table.setColumns(j4CColumns);
            });
        }
        return table;
    }

    public J4CColumn getForeignkey(J4CTable from, J4CTable join) {
        J4CColumn[] j4CColumn = new J4CColumn[]{null};
        try {
            Map<String, ForeignKey> foreignKeys = JDBC.fetchForeignKeys(this.connection, from.getName());
            Map<String, PrimaryKey> primaryKeys = JDBC.fetchPrimaryKeys(this.connection, join.getName());
            foreignKeys.entrySet().stream().filter(foreignKeyEntry -> ((String)foreignKeyEntry.getKey()).equals(from.getName())).findAny().ifPresent(foreignKey -> primaryKeys.entrySet().stream().filter(primaryKey -> ((String)primaryKey.getKey()).equals(join.getName())).findAny().ifPresent(primaryKey -> {
                j4CColumn[0] = new J4CColumn(from, ((ForeignKey)foreignKey.getValue()).getSource().getColumnName());
            }));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return j4CColumn[0];
    }

    public J4CColumn getPrimarykey(J4CTable table) {
        J4CColumn[] j4CColumn = new J4CColumn[]{null};
        try {
            Map<String, PrimaryKey> primaryKeys = JDBC.fetchPrimaryKeys(this.connection, table.getName());
            primaryKeys.entrySet().stream().filter(primaryKey -> ((String)primaryKey.getKey()).equals(table.getName())).findAny().ifPresent(primaryKey -> {
                j4CColumn[0] = new J4CColumn(table, ((PrimaryKey)primaryKey.getValue()).getSource().getColumnName());
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return j4CColumn[0];
    }
}

