/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.commons;

import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Geleia;
import cronapp.reports.commons.ParameterType;
import java.io.Serializable;
import org.w3c.dom.Element;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private ParameterType type;
    private Object value;

    public Parameter() {
    }

    public Parameter(String name, ParameterType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String name) {
        this.description = name;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        String value = this.value instanceof Element ? ((Element)this.value).getFirstChild().getNodeValue() : String.valueOf(this.value);
        switch (this.type) {
            case INTEGER: {
                return Geleia.intNotNull(value);
            }
            case DATE: {
                return Functions.getOnlyDate(value);
            }
            case DOUBLE: {
                return Geleia.doubleNotNull(value);
            }
            case FLOAT: {
                return Geleia.floatNotNull(value);
            }
            case BOOLEAN: {
                return Geleia.booleanNotNull(value);
            }
            case LONG: {
                return Geleia.longNotNull(value);
            }
        }
        return Geleia.stringNotNull(value);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.name != null ? !this.name.equals(parameter.name) : parameter.name != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals((Object)parameter.type) : parameter.type != null) {
            return false;
        }
        return this.value != null ? this.value.equals(parameter.value) : parameter.value == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Parameter{name='" + this.name + '\'' + ", type='" + (Object)((Object)this.type) + '\'' + ", value=" + this.value + '}';
    }
}

