/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.social.config.support.AbstractConnectionRepositoryConfigSupport;
import org.springframework.social.connect.mem.InMemoryUsersConnectionRepository;

public abstract class InMemoryConnectionRepositoryConfigSupport
extends AbstractConnectionRepositoryConfigSupport {
    private static final Log logger = LogFactory.getLog(InMemoryConnectionRepositoryConfigSupport.class);

    public BeanDefinition registerInMemoryConnectionRepositoryBeans(BeanDefinitionRegistry registry, String connectionRepositoryId, String usersConnectionRepositoryId, String connectionFactoryLocatorRef, String userIdSourceRef, String connectionSignUpRef) {
        this.registerUsersConnectionRepositoryBeanDefinition(registry, usersConnectionRepositoryId, connectionFactoryLocatorRef, connectionSignUpRef);
        return this.registerConnectionRepository(registry, usersConnectionRepositoryId, connectionRepositoryId, userIdSourceRef);
    }

    private BeanDefinition registerUsersConnectionRepositoryBeanDefinition(BeanDefinitionRegistry registry, String usersConnectionRepositoryId, String connectionFactoryLocatorRef, String connectionSignUpRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Registering InMemoryUsersConnectionRepository bean");
        }
        BeanDefinitionBuilder usersConnectionRepositoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(InMemoryUsersConnectionRepository.class).addConstructorArgReference(connectionFactoryLocatorRef);
        if (connectionSignUpRef != null && connectionSignUpRef.length() > 0) {
            usersConnectionRepositoryBeanBuilder.addPropertyReference("connectionSignUp", connectionSignUpRef);
        }
        AbstractBeanDefinition usersConnectionRepositoryBD = usersConnectionRepositoryBeanBuilder.getBeanDefinition();
        BeanDefinition scopedProxyBean = this.decorateWithScopedProxy(usersConnectionRepositoryId, (BeanDefinition)usersConnectionRepositoryBD, registry);
        registry.registerBeanDefinition(usersConnectionRepositoryId, scopedProxyBean);
        return scopedProxyBean;
    }
}

