/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.config.support;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.GenericTypeResolver;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.ConnectionFactoryRegistry;
import org.springframework.social.security.SocialAuthenticationServiceRegistry;
import org.springframework.social.security.provider.SocialAuthenticationService;
import org.springframework.util.ClassUtils;

public abstract class ProviderConfigurationSupport {
    private static final Log logger = LogFactory.getLog(ProviderConfigurationSupport.class);
    protected final Class<? extends ConnectionFactory<?>> connectionFactoryClass;
    protected final Class<? extends ApiHelper<?>> apiHelperClass;
    protected final Class<?> apiBindingType;
    protected Class<?> authenticationServiceClass;
    private static final String CONNECTION_FACTORY_LOCATOR_ID = "connectionFactoryLocator";
    private static final String CONNECTION_FACTORIES = "connectionFactories";
    private static final String AUTHENTICATION_SERVICES = "authenticationServices";

    public ProviderConfigurationSupport(Class<? extends ConnectionFactory<?>> connectionFactoryClass, Class<? extends ApiHelper<?>> apiHelperClass) {
        this.connectionFactoryClass = connectionFactoryClass;
        this.apiHelperClass = apiHelperClass;
        this.apiBindingType = GenericTypeResolver.resolveTypeArgument(connectionFactoryClass, ConnectionFactory.class);
        if (ProviderConfigurationSupport.isSocialSecurityAvailable()) {
            this.authenticationServiceClass = this.getAuthenticationServiceClass();
        }
    }

    protected Class<? extends SocialAuthenticationService<?>> getAuthenticationServiceClass() {
        return null;
    }

    protected static boolean isSocialSecurityAvailable() {
        try {
            Class.forName("org.springframework.social.security.SocialAuthenticationServiceLocator");
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    protected BeanDefinition getConnectionFactoryBeanDefinition(String appId, String appSecret, Map<String, Object> allAttributes) {
        return BeanDefinitionBuilder.genericBeanDefinition(this.connectionFactoryClass).addConstructorArgValue((Object)appId).addConstructorArgValue((Object)appSecret).getBeanDefinition();
    }

    protected BeanDefinition getAuthenticationServiceBeanDefinition(String appId, String appSecret, Map<String, Object> allAttributes) {
        return BeanDefinitionBuilder.genericBeanDefinition(this.authenticationServiceClass).addConstructorArgValue((Object)appId).addConstructorArgValue((Object)appSecret).getBeanDefinition();
    }

    protected BeanDefinition registerBeanDefinitions(BeanDefinitionRegistry registry, Map<String, Object> allAttributes) {
        if (ProviderConfigurationSupport.isSocialSecurityAvailable() && this.authenticationServiceClass != null) {
            this.registerAuthenticationServiceBeanDefinitions(registry, allAttributes);
        } else {
            this.registerConnectionFactoryBeanDefinitions(registry, allAttributes);
        }
        return this.registerApiBindingBean(registry, this.apiHelperClass, this.apiBindingType);
    }

    protected abstract String getAppId(Map<String, Object> var1);

    protected abstract String getAppSecret(Map<String, Object> var1);

    private void registerConnectionFactoryBeanDefinitions(BeanDefinitionRegistry registry, Map<String, Object> allAttributes) {
        BeanDefinition connectionFactoryBD = this.getConnectionFactoryBeanDefinition(this.getAppId(allAttributes), this.getAppSecret(allAttributes), allAttributes);
        BeanDefinition connectionFactoryLocatorBD = this.registerConnectionFactoryLocatorBean(registry);
        this.registerConnectionFactoryBean(connectionFactoryLocatorBD, connectionFactoryBD, this.connectionFactoryClass);
    }

    private void registerAuthenticationServiceBeanDefinitions(BeanDefinitionRegistry registry, Map<String, Object> allAttributes) {
        Class<?> socialAuthenticationServiceClass = this.authenticationServiceClass;
        BeanDefinition authenticationServiceBD = this.getAuthenticationServiceBeanDefinition(this.getAppId(allAttributes), this.getAppSecret(allAttributes), allAttributes);
        BeanDefinition connectionFactoryLocatorBD = this.registerConnectionFactoryLocatorBean(registry);
        this.registerAuthenticationServiceBean(connectionFactoryLocatorBD, authenticationServiceBD, socialAuthenticationServiceClass);
    }

    private BeanDefinition registerConnectionFactoryLocatorBean(BeanDefinitionRegistry registry) {
        Class connectionFactoryRegistryClass;
        Class clazz = connectionFactoryRegistryClass = ProviderConfigurationSupport.isSocialSecurityAvailable() ? SocialAuthenticationServiceRegistry.class : ConnectionFactoryRegistry.class;
        if (!registry.containsBeanDefinition(CONNECTION_FACTORY_LOCATOR_ID)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering ConnectionFactoryLocator bean (" + connectionFactoryRegistryClass.getName() + ")"));
            }
            BeanDefinitionHolder connFactoryLocatorBeanDefHolder = new BeanDefinitionHolder((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(connectionFactoryRegistryClass).getBeanDefinition(), CONNECTION_FACTORY_LOCATOR_ID);
            BeanDefinitionHolder scopedProxy = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)connFactoryLocatorBeanDefHolder, (BeanDefinitionRegistry)registry, (boolean)false);
            registry.registerBeanDefinition(scopedProxy.getBeanName(), scopedProxy.getBeanDefinition());
        }
        BeanDefinition connectionFactoryLocatorBD = registry.getBeanDefinition(ScopedProxyUtils.getTargetBeanName((String)CONNECTION_FACTORY_LOCATOR_ID));
        return connectionFactoryLocatorBD;
    }

    private BeanDefinition registerConnectionFactoryBean(BeanDefinition connectionFactoryLocatorBD, BeanDefinition connectionFactoryBD, Class<? extends ConnectionFactory<?>> connectionFactoryClass) {
        PropertyValue connectionFactoriesPropertyValue;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering ConnectionFactory: " + connectionFactoryClass.getName()));
        }
        List connectionFactoriesList = (connectionFactoriesPropertyValue = connectionFactoryLocatorBD.getPropertyValues().getPropertyValue(CONNECTION_FACTORIES)) != null ? (List)connectionFactoriesPropertyValue.getValue() : new ManagedList();
        connectionFactoriesList.add(connectionFactoryBD);
        connectionFactoryLocatorBD.getPropertyValues().addPropertyValue(CONNECTION_FACTORIES, (Object)connectionFactoriesList);
        return connectionFactoryBD;
    }

    private BeanDefinition registerAuthenticationServiceBean(BeanDefinition authenticationServiceLocatorBD, BeanDefinition authenticationServiceBD, Class<? extends SocialAuthenticationService<?>> socialAuthenticationServiceClass) {
        PropertyValue authenticationServicesPropertyValue;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering SocialAuthenticationService: " + socialAuthenticationServiceClass.getName()));
        }
        List authenticationServicesList = (authenticationServicesPropertyValue = authenticationServiceLocatorBD.getPropertyValues().getPropertyValue(AUTHENTICATION_SERVICES)) != null ? (List)authenticationServicesPropertyValue.getValue() : new ManagedList();
        authenticationServicesList.add(authenticationServiceBD);
        authenticationServiceLocatorBD.getPropertyValues().addPropertyValue(AUTHENTICATION_SERVICES, (Object)authenticationServicesList);
        return authenticationServiceBD;
    }

    private BeanDefinition registerApiBindingBean(BeanDefinitionRegistry registry, Class<? extends ApiHelper<?>> apiHelperClass, Class<?> apiBindingType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering API Helper bean for " + ClassUtils.getShortName(apiBindingType)));
        }
        String helperId = "__" + ClassUtils.getShortNameAsProperty(apiBindingType) + "ApiHelper";
        AbstractBeanDefinition helperBD = BeanDefinitionBuilder.genericBeanDefinition(apiHelperClass).addConstructorArgReference("usersConnectionRepository").addConstructorArgReference("userIdSource").getBeanDefinition();
        registry.registerBeanDefinition(helperId, (BeanDefinition)helperBD);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating API Binding bean for " + ClassUtils.getShortName(apiBindingType)));
        }
        AbstractBeanDefinition bindingBD = BeanDefinitionBuilder.genericBeanDefinition().getBeanDefinition();
        bindingBD.setFactoryBeanName(helperId);
        bindingBD.setFactoryMethodName("getApi");
        bindingBD.setScope("request");
        BeanDefinitionHolder scopedProxyBDH = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)bindingBD, ClassUtils.getShortNameAsProperty(apiBindingType)), (BeanDefinitionRegistry)registry, (boolean)false);
        registry.registerBeanDefinition(scopedProxyBDH.getBeanName(), scopedProxyBDH.getBeanDefinition());
        return scopedProxyBDH.getBeanDefinition();
    }
}

