/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect;

import org.springframework.social.ServiceProvider;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.NullApiAdapter;

public abstract class ConnectionFactory<A> {
    private final String providerId;
    private final ServiceProvider<A> serviceProvider;
    private final ApiAdapter<A> apiAdapter;

    public ConnectionFactory(String providerId, ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        this.providerId = providerId;
        this.serviceProvider = serviceProvider;
        this.apiAdapter = this.nullSafeApiAdapter(apiAdapter);
    }

    public String getProviderId() {
        return this.providerId;
    }

    protected ServiceProvider<A> getServiceProvider() {
        return this.serviceProvider;
    }

    protected ApiAdapter<A> getApiAdapter() {
        return this.apiAdapter;
    }

    public abstract Connection<A> createConnection(ConnectionData var1);

    private ApiAdapter<A> nullSafeApiAdapter(ApiAdapter<A> apiAdapter) {
        if (apiAdapter != null) {
            return apiAdapter;
        }
        return NullApiAdapter.INSTANCE;
    }
}

