/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import java.util.UUID;
import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.support.OAuth2Connection;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2ServiceProvider;

public class OAuth2ConnectionFactory<S>
extends ConnectionFactory<S> {
    private String scope = null;

    public OAuth2ConnectionFactory(String providerId, OAuth2ServiceProvider<S> serviceProvider, ApiAdapter<S> apiAdapter) {
        super(providerId, serviceProvider, apiAdapter);
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public String generateState() {
        return UUID.randomUUID().toString();
    }

    public boolean supportsStateParameter() {
        return true;
    }

    public OAuth2Operations getOAuthOperations() {
        return this.getOAuth2ServiceProvider().getOAuthOperations();
    }

    public Connection<S> createConnection(AccessGrant accessGrant) {
        return new OAuth2Connection<S>(this.getProviderId(), this.extractProviderUserId(accessGrant), accessGrant.getAccessToken(), accessGrant.getRefreshToken(), accessGrant.getExpireTime(), this.getOAuth2ServiceProvider(), this.getApiAdapter());
    }

    @Override
    public Connection<S> createConnection(ConnectionData data) {
        return new OAuth2Connection<S>(data, this.getOAuth2ServiceProvider(), this.getApiAdapter());
    }

    protected String extractProviderUserId(AccessGrant accessGrant) {
        return null;
    }

    private OAuth2ServiceProvider<S> getOAuth2ServiceProvider() {
        return (OAuth2ServiceProvider)this.getServiceProvider();
    }
}

