/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth1;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.EmptyMultiValueMap;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuth1Version;
import org.springframework.social.oauth1.OAuthToken;
import org.springframework.social.oauth1.SigningSupport;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth1Template
implements OAuth1Operations {
    private final String consumerKey;
    private final String consumerSecret;
    private final URI requestTokenUrl;
    private final String authenticateUrl;
    private final String authorizeUrl;
    private final URI accessTokenUrl;
    private final RestTemplate restTemplate;
    private final OAuth1Version version;
    private final SigningSupport signingUtils;

    public OAuth1Template(String consumerKey, String consumerSecret, String requestTokenUrl, String authorizeUrl, String accessTokenUrl) {
        this(consumerKey, consumerSecret, requestTokenUrl, authorizeUrl, accessTokenUrl, OAuth1Version.CORE_10_REVISION_A);
    }

    public OAuth1Template(String consumerKey, String consumerSecret, String requestTokenUrl, String authorizeUrl, String accessTokenUrl, OAuth1Version version) {
        this(consumerKey, consumerSecret, requestTokenUrl, authorizeUrl, null, accessTokenUrl, version);
    }

    public OAuth1Template(String consumerKey, String consumerSecret, String requestTokenUrl, String authorizeUrl, String authenticateUrl, String accessTokenUrl) {
        this(consumerKey, consumerSecret, requestTokenUrl, authorizeUrl, authenticateUrl, accessTokenUrl, OAuth1Version.CORE_10_REVISION_A);
    }

    public OAuth1Template(String consumerKey, String consumerSecret, String requestTokenUrl, String authorizeUrl, String authenticateUrl, String accessTokenUrl, OAuth1Version version) {
        Assert.notNull((Object)consumerKey, (String)"The consumerKey property cannot be null");
        Assert.notNull((Object)consumerSecret, (String)"The consumerSecret property cannot be null");
        Assert.notNull((Object)requestTokenUrl, (String)"The requestTokenUrl property cannot be null");
        Assert.notNull((Object)authorizeUrl, (String)"The authorizeUrl property cannot be null");
        Assert.notNull((Object)accessTokenUrl, (String)"The accessTokenUrl property cannot be null");
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.requestTokenUrl = this.encodeTokenUri(requestTokenUrl);
        this.authorizeUrl = authorizeUrl;
        this.authenticateUrl = authenticateUrl;
        this.accessTokenUrl = this.encodeTokenUri(accessTokenUrl);
        this.version = version;
        this.restTemplate = this.createRestTemplate();
        this.signingUtils = new SigningSupport();
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"The requestFactory property cannot be null");
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public OAuth1Version getVersion() {
        return this.version;
    }

    @Override
    public OAuthToken fetchRequestToken(String callbackUrl, MultiValueMap<String, String> additionalParameters) {
        HashMap<String, String> oauthParameters = new HashMap<String, String>(1, 1.0f);
        if (this.version == OAuth1Version.CORE_10_REVISION_A) {
            oauthParameters.put("oauth_callback", callbackUrl);
        }
        return this.exchangeForToken(this.requestTokenUrl, oauthParameters, additionalParameters, null);
    }

    @Override
    public String buildAuthorizeUrl(String requestToken, OAuth1Parameters parameters) {
        return this.buildAuthUrl(this.authorizeUrl, requestToken, parameters);
    }

    @Override
    public String buildAuthenticateUrl(String requestToken, OAuth1Parameters parameters) {
        return this.authenticateUrl != null ? this.buildAuthUrl(this.authenticateUrl, requestToken, parameters) : this.buildAuthorizeUrl(requestToken, parameters);
    }

    @Override
    public OAuthToken exchangeForAccessToken(AuthorizedRequestToken requestToken, MultiValueMap<String, String> additionalParameters) {
        HashMap<String, String> tokenParameters = new HashMap<String, String>(2, 1.0f);
        tokenParameters.put("oauth_token", requestToken.getValue());
        if (this.version == OAuth1Version.CORE_10_REVISION_A) {
            tokenParameters.put("oauth_verifier", requestToken.getVerifier());
        }
        return this.exchangeForToken(this.accessTokenUrl, tokenParameters, additionalParameters, requestToken.getSecret());
    }

    protected String getConsumerKey() {
        return this.consumerKey;
    }

    protected OAuthToken createOAuthToken(String tokenValue, String tokenSecret, MultiValueMap<String, String> response) {
        return new OAuthToken(tokenValue, tokenSecret);
    }

    protected void addCustomAuthorizationParameters(MultiValueMap<String, String> parameters) {
    }

    private RestTemplate createRestTemplate() {
        RestTemplate restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        ArrayList<1> converters = new ArrayList<1>(1);
        converters.add(new FormHttpMessageConverter(){

            public boolean canRead(Class<?> clazz, MediaType mediaType) {
                return MultiValueMap.class.isAssignableFrom(clazz);
            }
        });
        restTemplate.setMessageConverters(converters);
        return restTemplate;
    }

    private URI encodeTokenUri(String url) {
        return UriComponentsBuilder.fromUriString((String)url).build().toUri();
    }

    private OAuthToken exchangeForToken(URI tokenUrl, Map<String, String> tokenParameters, MultiValueMap<String, String> additionalParameters, String tokenSecret) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.buildAuthorizationHeaderValue(tokenUrl, tokenParameters, additionalParameters, tokenSecret));
        ResponseEntity response = this.restTemplate.exchange(tokenUrl, HttpMethod.POST, new HttpEntity(additionalParameters, (MultiValueMap)headers), MultiValueMap.class);
        MultiValueMap body = (MultiValueMap)response.getBody();
        return this.createOAuthToken((String)body.getFirst((Object)"oauth_token"), (String)body.getFirst((Object)"oauth_token_secret"), (MultiValueMap<String, String>)body);
    }

    private String buildAuthorizationHeaderValue(URI tokenUrl, Map<String, String> tokenParameters, MultiValueMap<String, String> additionalParameters, String tokenSecret) {
        Map<String, String> oauthParameters = this.signingUtils.commonOAuthParameters(this.consumerKey);
        oauthParameters.putAll(tokenParameters);
        if (additionalParameters == null) {
            additionalParameters = EmptyMultiValueMap.instance();
        }
        return this.signingUtils.buildAuthorizationHeaderValue(HttpMethod.POST, tokenUrl, oauthParameters, (MultiValueMap<String, String>)additionalParameters, this.consumerSecret, tokenSecret);
    }

    private String buildAuthUrl(String baseAuthUrl, String requestToken, OAuth1Parameters parameters) {
        StringBuilder authUrl = new StringBuilder(baseAuthUrl).append('?').append("oauth_token").append('=').append(this.formEncode(requestToken));
        this.addCustomAuthorizationParameters(parameters);
        if (parameters != null) {
            for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
                String name = this.formEncode(param.getKey());
                Iterator<String> values = param.getValue().iterator();
                while (values.hasNext()) {
                    authUrl.append('&').append(name).append('=').append(this.formEncode(values.next()));
                }
            }
        }
        return authUrl.toString();
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

