/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.support;

import org.springframework.social.connect.ApiAdapter;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.support.AbstractConnection;
import org.springframework.social.oauth1.OAuth1ServiceProvider;

public class OAuth1Connection<A>
extends AbstractConnection<A> {
    private final OAuth1ServiceProvider<A> serviceProvider;
    private String accessToken;
    private String secret;
    private A api;

    public OAuth1Connection(String providerId, String providerUserId, String accessToken, String secret, OAuth1ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(accessToken, secret);
        this.initApi();
        this.initKey(providerId, providerUserId);
    }

    public OAuth1Connection(ConnectionData data, OAuth1ServiceProvider<A> serviceProvider, ApiAdapter<A> apiAdapter) {
        super(data, apiAdapter);
        this.serviceProvider = serviceProvider;
        this.initAccessTokens(data.getAccessToken(), data.getSecret());
        this.initApi();
    }

    @Override
    public A getApi() {
        return this.api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionData createData() {
        Object object = this.getMonitor();
        synchronized (object) {
            return new ConnectionData(this.getKey().getProviderId(), this.getKey().getProviderUserId(), this.getDisplayName(), this.getProfileUrl(), this.getImageUrl(), this.accessToken, this.secret, null, null);
        }
    }

    private void initAccessTokens(String accessToken, String secret) {
        this.accessToken = accessToken;
        this.secret = secret;
    }

    private void initApi() {
        this.api = this.serviceProvider.getApi(this.accessToken, this.secret);
    }
}

