/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.ApiBinding;
import org.springframework.social.oauth2.OAuth2RequestInterceptor;
import org.springframework.social.oauth2.OAuth2Version;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractOAuth2ApiBinding
implements ApiBinding {
    private final String accessToken;
    private final RestTemplate restTemplate;

    protected AbstractOAuth2ApiBinding() {
        this.accessToken = null;
        this.restTemplate = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        this.restTemplate.setMessageConverters(this.getMessageConverters());
        this.configureRestTemplate(this.restTemplate);
    }

    protected AbstractOAuth2ApiBinding(String accessToken) {
        this.accessToken = accessToken;
        this.restTemplate = this.createRestTemplate(accessToken, this.getOAuth2Version());
        this.restTemplate.setMessageConverters(this.getMessageConverters());
        this.configureRestTemplate(this.restTemplate);
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        this.restTemplate.setRequestFactory(requestFactory);
    }

    @Override
    public boolean isAuthorized() {
        return this.accessToken != null;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    protected OAuth2Version getOAuth2Version() {
        return OAuth2Version.BEARER;
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getFormMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getJsonMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getByteArrayMessageConverter());
        return messageConverters;
    }

    protected FormHttpMessageConverter getFormMessageConverter() {
        FormHttpMessageConverter converter = new FormHttpMessageConverter();
        converter.setCharset(Charset.forName("UTF-8"));
        ArrayList<Object> partConverters = new ArrayList<Object>();
        partConverters.add(new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        partConverters.add(stringHttpMessageConverter);
        partConverters.add(new ResourceHttpMessageConverter());
        converter.setPartConverters(partConverters);
        return converter;
    }

    protected MappingJackson2HttpMessageConverter getJsonMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }

    protected ByteArrayHttpMessageConverter getByteArrayMessageConverter() {
        ByteArrayHttpMessageConverter converter = new ByteArrayHttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.IMAGE_JPEG, MediaType.IMAGE_GIF, MediaType.IMAGE_PNG));
        return converter;
    }

    private RestTemplate createRestTemplate(String accessToken, OAuth2Version version) {
        RestTemplate client = new RestTemplate(ClientHttpRequestFactorySelector.getRequestFactory());
        OAuth2RequestInterceptor interceptor = new OAuth2RequestInterceptor(accessToken, version);
        LinkedList<OAuth2RequestInterceptor> interceptors = new LinkedList<OAuth2RequestInterceptor>();
        interceptors.add(interceptor);
        client.setInterceptors(interceptors);
        return client;
    }
}

