/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.GrantType;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Parameters;
import org.springframework.social.oauth2.PreemptiveBasicAuthClientHttpRequestInterceptor;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OAuth2Template
implements OAuth2Operations {
    private final String clientId;
    private final String clientSecret;
    private final String accessTokenUrl;
    private final String authorizeUrl;
    private String authenticateUrl;
    private RestTemplate restTemplate;
    private boolean useParametersForClientAuthentication;

    public OAuth2Template(String clientId, String clientSecret, String authorizeUrl, String accessTokenUrl) {
        this(clientId, clientSecret, authorizeUrl, null, accessTokenUrl);
    }

    public OAuth2Template(String clientId, String clientSecret, String authorizeUrl, String authenticateUrl, String accessTokenUrl) {
        Assert.notNull((Object)clientId, (String)"The clientId property cannot be null");
        Assert.notNull((Object)clientSecret, (String)"The clientSecret property cannot be null");
        Assert.notNull((Object)authorizeUrl, (String)"The authorizeUrl property cannot be null");
        Assert.notNull((Object)accessTokenUrl, (String)"The accessTokenUrl property cannot be null");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        String clientInfo = "?client_id=" + this.formEncode(clientId);
        this.authorizeUrl = authorizeUrl + clientInfo;
        this.authenticateUrl = authenticateUrl != null ? authenticateUrl + clientInfo : null;
        this.accessTokenUrl = accessTokenUrl;
    }

    public void setUseParametersForClientAuthentication(boolean useParametersForClientAuthentication) {
        this.useParametersForClientAuthentication = useParametersForClientAuthentication;
    }

    public void setRequestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"The requestFactory property cannot be null");
        this.getRestTemplate().setRequestFactory(requestFactory);
    }

    @Override
    public String buildAuthorizeUrl(GrantType grantType, OAuth2Parameters parameters) {
        return this.buildAuthUrl(this.authorizeUrl, grantType, parameters);
    }

    @Override
    public String buildAuthenticateUrl(GrantType grantType, OAuth2Parameters parameters) {
        return this.authenticateUrl != null ? this.buildAuthUrl(this.authenticateUrl, grantType, parameters) : this.buildAuthorizeUrl(grantType, parameters);
    }

    @Override
    public AccessGrant exchangeForAccess(String authorizationCode, String redirectUri, MultiValueMap<String, String> additionalParameters) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.useParametersForClientAuthentication) {
            params.set((Object)"client_id", (Object)this.clientId);
            params.set((Object)"client_secret", (Object)this.clientSecret);
        }
        params.set((Object)"code", (Object)authorizationCode);
        params.set((Object)"redirect_uri", (Object)redirectUri);
        params.set((Object)"grant_type", (Object)"authorization_code");
        if (additionalParameters != null) {
            params.putAll(additionalParameters);
        }
        return this.postForAccessGrant(this.accessTokenUrl, (MultiValueMap<String, String>)params);
    }

    @Override
    public AccessGrant exchangeCredentialsForAccess(String username, String password, MultiValueMap<String, String> additionalParameters) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.useParametersForClientAuthentication) {
            params.set((Object)"client_id", (Object)this.clientId);
            params.set((Object)"client_secret", (Object)this.clientSecret);
        }
        params.set((Object)"username", (Object)username);
        params.set((Object)"password", (Object)password);
        params.set((Object)"grant_type", (Object)"password");
        if (additionalParameters != null) {
            params.putAll(additionalParameters);
        }
        return this.postForAccessGrant(this.accessTokenUrl, (MultiValueMap<String, String>)params);
    }

    @Override
    public AccessGrant refreshAccess(String refreshToken, String scope, MultiValueMap<String, String> additionalParameters) {
        additionalParameters.set((Object)"scope", (Object)scope);
        return this.refreshAccess(refreshToken, additionalParameters);
    }

    @Override
    public AccessGrant refreshAccess(String refreshToken, MultiValueMap<String, String> additionalParameters) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.useParametersForClientAuthentication) {
            params.set((Object)"client_id", (Object)this.clientId);
            params.set((Object)"client_secret", (Object)this.clientSecret);
        }
        params.set((Object)"refresh_token", (Object)refreshToken);
        params.set((Object)"grant_type", (Object)"refresh_token");
        if (additionalParameters != null) {
            params.putAll(additionalParameters);
        }
        return this.postForAccessGrant(this.accessTokenUrl, (MultiValueMap<String, String>)params);
    }

    @Override
    public AccessGrant authenticateClient() {
        return this.authenticateClient(null);
    }

    @Override
    public AccessGrant authenticateClient(String scope) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (this.useParametersForClientAuthentication) {
            params.set((Object)"client_id", (Object)this.clientId);
            params.set((Object)"client_secret", (Object)this.clientSecret);
        }
        params.set((Object)"grant_type", (Object)"client_credentials");
        if (scope != null) {
            params.set((Object)"scope", (Object)scope);
        }
        return this.postForAccessGrant(this.accessTokenUrl, (MultiValueMap<String, String>)params);
    }

    protected RestTemplate createRestTemplate() {
        ClientHttpRequestFactory requestFactory = ClientHttpRequestFactorySelector.getRequestFactory();
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        ArrayList<Object> converters = new ArrayList<Object>(2);
        converters.add(new FormHttpMessageConverter());
        converters.add(new MappingJackson2HttpMessageConverter());
        restTemplate.setMessageConverters(converters);
        if (!this.useParametersForClientAuthentication) {
            restTemplate.getInterceptors().add(new PreemptiveBasicAuthClientHttpRequestInterceptor(this.clientId, this.clientSecret));
        }
        return restTemplate;
    }

    protected AccessGrant postForAccessGrant(String accessTokenUrl, MultiValueMap<String, String> parameters) {
        return this.extractAccessGrant((Map)this.getRestTemplate().postForObject(accessTokenUrl, parameters, Map.class, new Object[0]));
    }

    protected AccessGrant createAccessGrant(String accessToken, String scope, String refreshToken, Long expiresIn, Map<String, Object> response) {
        return new AccessGrant(accessToken, scope, refreshToken, expiresIn);
    }

    protected RestTemplate getRestTemplate() {
        if (this.restTemplate == null) {
            this.restTemplate = this.createRestTemplate();
        }
        return this.restTemplate;
    }

    private String buildAuthUrl(String baseAuthUrl, GrantType grantType, OAuth2Parameters parameters) {
        StringBuilder authUrl = new StringBuilder(baseAuthUrl);
        if (grantType == GrantType.AUTHORIZATION_CODE) {
            authUrl.append('&').append("response_type").append('=').append("code");
        } else if (grantType == GrantType.IMPLICIT_GRANT) {
            authUrl.append('&').append("response_type").append('=').append("token");
        }
        for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
            String name = this.formEncode(param.getKey());
            Iterator<String> values = param.getValue().iterator();
            while (values.hasNext()) {
                authUrl.append('&').append(name).append('=').append(this.formEncode(values.next()));
            }
        }
        return authUrl.toString();
    }

    private String formEncode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private AccessGrant extractAccessGrant(Map<String, Object> result) {
        return this.createAccessGrant((String)result.get("access_token"), (String)result.get("scope"), (String)result.get("refresh_token"), this.getIntegerValue(result, "expires_in"), result);
    }

    private Long getIntegerValue(Map<String, Object> map, String key) {
        try {
            return Long.valueOf(String.valueOf(map.get(key)));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

