/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.oauth2;

public enum OAuth2Version {
    BEARER{

        @Override
        public String getAuthorizationHeaderValue(String accessToken) {
            return "Bearer " + accessToken;
        }
    }
    ,
    BEARER_DRAFT_2{

        @Override
        public String getAuthorizationHeaderValue(String accessToken) {
            return "OAuth2 " + accessToken;
        }
    }
    ,
    DRAFT_10{

        @Override
        public String getAuthorizationHeaderValue(String accessToken) {
            return "OAuth " + accessToken;
        }
    }
    ,
    DRAFT_8{

        @Override
        public String getAuthorizationHeaderValue(String accessToken) {
            return "Token token=\"" + accessToken + "\"";
        }
    };


    public abstract String getAuthorizationHeaderValue(String var1);
}

