/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.api.impl.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.Date;
import org.springframework.social.facebook.api.Album;
import org.springframework.social.facebook.api.Page;
import org.springframework.social.facebook.api.Reference;
import org.springframework.social.facebook.api.impl.json.FacebookObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
abstract class AlbumMixin
extends FacebookObjectMixin {
    @JsonProperty(value="id")
    String id;
    @JsonProperty(value="backdated_time")
    Date backdatedTime;
    @JsonProperty(value="can_upload")
    boolean canUpload;
    @JsonProperty(value="count")
    int count;
    @JsonProperty(value="cover_photo")
    String coverPhoto;
    @JsonProperty(value="created_time")
    Date createdTime;
    @JsonProperty(value="description")
    String description;
    @JsonProperty(value="from")
    Reference from;
    @JsonProperty(value="link")
    String link;
    @JsonProperty(value="location")
    String location;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="place")
    Page place;
    @JsonProperty(value="privacy")
    @JsonDeserialize(using=PrivacyDeserializer.class)
    Album.Privacy privacy;
    @JsonProperty(value="type")
    @JsonDeserialize(using=TypeDeserializer.class)
    Album.Type type;
    @JsonProperty(value="updated_time")
    Date updatedTime;

    AlbumMixin() {
    }

    private static class PrivacyDeserializer
    extends JsonDeserializer<Album.Privacy> {
        private PrivacyDeserializer() {
        }

        public Album.Privacy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Album.Privacy.valueOf(jp.getText().replace("-", "_").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Album.Privacy.CUSTOM;
            }
        }
    }

    private static class TypeDeserializer
    extends JsonDeserializer<Album.Type> {
        private TypeDeserializer() {
        }

        public Album.Type deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return Album.Type.valueOf(jp.getText().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return Album.Type.UNKNOWN;
            }
        }
    }
}

