/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.facebook.security;

import java.io.IOException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.social.support.HttpRequestDecorator;

public class FacebookAppSecretProofInterceptor
implements ClientHttpRequestInterceptor {
    private final String appSecret;
    private final String appToken;
    private static final String algorithm = "HmacSHA256";

    public FacebookAppSecretProofInterceptor(String appToken, String appSecret) {
        this.appSecret = appSecret;
        this.appToken = appToken;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestDecorator protectedResourceRequest = new HttpRequestDecorator(request);
        String appSecreteProof = this.calculateAppSecretProof(this.appToken, this.appSecret);
        protectedResourceRequest.addParameter("appsecret_proof", appSecreteProof);
        return execution.execute((HttpRequest)protectedResourceRequest, body);
    }

    private String calculateAppSecretProof(String token, String appSecret) {
        try {
            Mac mac = Mac.getInstance(algorithm);
            SecretKeySpec secretKey = new SecretKeySpec(appSecret.getBytes("UTF-8"), algorithm);
            mac.init(secretKey);
            byte[] digest = mac.doFinal(token.getBytes());
            return new String(Hex.encode((byte[])digest));
        }
        catch (Exception e) {
            return "";
        }
    }
}

