/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.api.impl;

import java.util.Arrays;
import java.util.List;
import org.springframework.social.github.api.GitHubCommit;
import org.springframework.social.github.api.GitHubDownload;
import org.springframework.social.github.api.GitHubHook;
import org.springframework.social.github.api.GitHubRepo;
import org.springframework.social.github.api.GitHubUser;
import org.springframework.social.github.api.RepoOperations;
import org.springframework.social.github.api.impl.AbstractGitHubOperations;
import org.springframework.web.client.RestTemplate;

public class RepoTemplate
extends AbstractGitHubOperations
implements RepoOperations {
    private final RestTemplate restTemplate;

    public RepoTemplate(RestTemplate restTemplate, boolean isAuthorizedForUser) {
        super(isAuthorizedForUser);
        this.restTemplate = restTemplate;
    }

    @Override
    public GitHubRepo getRepo(String user, String repo) {
        return (GitHubRepo)this.restTemplate.getForObject(this.buildRepoUri(""), GitHubRepo.class, new Object[]{user, repo});
    }

    @Override
    public List<GitHubUser> getCollaborators(String user, String repo) {
        return Arrays.asList((GitHubUser[])this.restTemplate.getForObject(this.buildRepoUri("/collaborators"), GitHubUser[].class, new Object[]{user, repo}));
    }

    @Override
    public List<GitHubCommit> getCommits(String user, String repo) {
        return Arrays.asList((GitHubCommit[])this.restTemplate.getForObject(this.buildRepoUri("/commits"), GitHubCommit[].class, new Object[]{user, repo}));
    }

    @Override
    public List<GitHubDownload> getDownloads(String user, String repo) {
        return Arrays.asList((GitHubDownload[])this.restTemplate.getForObject(this.buildRepoUri("/downloads"), GitHubDownload[].class, new Object[]{user, repo}));
    }

    @Override
    public GitHubDownload getDownload(String user, String repo, Long id) {
        String uri = this.buildUri("repos/{user}/{repo}/downloads/{id}");
        return (GitHubDownload)this.restTemplate.getForObject(uri, GitHubDownload.class, new Object[]{user, repo, id});
    }

    @Override
    public List<GitHubRepo> getForks(String user, String repo) {
        return Arrays.asList((GitHubRepo[])this.restTemplate.getForObject(this.buildRepoUri("/forks"), GitHubRepo[].class, new Object[]{user, repo}));
    }

    @Override
    public List<GitHubUser> getWatchers(String user, String repo) {
        return Arrays.asList((GitHubUser[])this.restTemplate.getForObject(this.buildRepoUri("/watchers"), GitHubUser[].class, new Object[]{user, repo}));
    }

    @Override
    public List<GitHubHook> getHooks(String user, String repo) {
        return Arrays.asList((GitHubHook[])this.restTemplate.getForObject(this.buildRepoUri("/hooks"), GitHubHook[].class, new Object[]{user, repo}));
    }

    private String buildRepoUri(String path) {
        return this.buildUri("repos/{user}/{repo}" + path);
    }
}

