/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.github.config.annotation;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.AbstractProviderConfigRegistrarSupport;
import org.springframework.social.config.xml.ApiHelper;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.github.api.GitHub;
import org.springframework.social.github.api.impl.GitHubTemplate;
import org.springframework.social.github.config.annotation.EnableGitHub;
import org.springframework.social.github.connect.GitHubConnectionFactory;
import org.springframework.social.github.security.GitHubAuthenticationService;
import org.springframework.social.security.provider.SocialAuthenticationService;

public class GitHubProviderConfigRegistrar
extends AbstractProviderConfigRegistrarSupport {
    public GitHubProviderConfigRegistrar() {
        super(EnableGitHub.class, GitHubConnectionFactory.class, GitHubApiHelper.class);
    }

    protected Class<? extends SocialAuthenticationService<?>> getAuthenticationServiceClass() {
        return GitHubAuthenticationService.class;
    }

    static class GitHubApiHelper
    implements ApiHelper<GitHub> {
        private final UsersConnectionRepository usersConnectionRepository;
        private final UserIdSource userIdSource;
        private static final Log logger = LogFactory.getLog(GitHubApiHelper.class);

        private GitHubApiHelper(UsersConnectionRepository usersConnectionRepository, UserIdSource userIdSource) {
            this.usersConnectionRepository = usersConnectionRepository;
            this.userIdSource = userIdSource;
        }

        public GitHub getApi() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Getting API binding instance for Facebook provider");
            }
            Connection connection = this.usersConnectionRepository.createConnectionRepository(this.userIdSource.getUserId()).findPrimaryConnection(GitHub.class);
            if (logger.isDebugEnabled() && connection == null) {
                logger.debug((Object)"No current connection; Returning default FacebookTemplate instance.");
            }
            return connection != null ? (GitHub)connection.getApi() : new GitHubTemplate();
        }
    }
}

