/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.calendar.impl;

import org.springframework.social.google.api.calendar.Calendar;
import org.springframework.social.google.api.calendar.CalendarListQueryBuilder;
import org.springframework.social.google.api.calendar.CalendarOperations;
import org.springframework.social.google.api.calendar.CalendarPage;
import org.springframework.social.google.api.calendar.Event;
import org.springframework.social.google.api.calendar.EventListQueryBuilder;
import org.springframework.social.google.api.calendar.EventPage;
import org.springframework.social.google.api.calendar.impl.CalendarGetQueryBuilderImpl;
import org.springframework.social.google.api.calendar.impl.CalendarListQueryBuilderImpl;
import org.springframework.social.google.api.calendar.impl.DeleteEventBuilderImpl;
import org.springframework.social.google.api.calendar.impl.EventGetQueryBuilderImpl;
import org.springframework.social.google.api.calendar.impl.EventListQueryBuilderImpl;
import org.springframework.social.google.api.calendar.impl.QuickAddEventBuilderImpl;
import org.springframework.social.google.api.calendar.impl.UpdateEventBuilderImpl;
import org.springframework.social.google.api.impl.AbstractGoogleApiOperations;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class CalendarTemplate
extends AbstractGoogleApiOperations
implements CalendarOperations {
    private static final String CALENDAR_BASE_URL = "https://www.googleapis.com/calendar/v3";

    public CalendarTemplate(RestTemplate restTemplate, boolean isAuthorized) {
        super(restTemplate, isAuthorized);
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
    }

    @Override
    public CalendarListQueryBuilder calendarListQuery() {
        return new CalendarListQueryBuilderImpl("https://www.googleapis.com/calendar/v3/users/me/calendarList", CalendarPage.class, this.restTemplate);
    }

    @Override
    public EventListQueryBuilder eventListQuery(String calendarId) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        return new EventListQueryBuilderImpl("https://www.googleapis.com/calendar/v3/calendars/{0}/events", calendarId, EventPage.class, this.restTemplate);
    }

    @Override
    public Calendar getCalendar(String calendarId) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        CalendarGetQueryBuilderImpl builder = new CalendarGetQueryBuilderImpl("https://www.googleapis.com/calendar/v3/users/me/calendarList/{0}", calendarId);
        return (Calendar)this.restTemplate.getForObject(builder.buildUri(), Calendar.class);
    }

    @Override
    public Event getEvent(String calendarId, String eventId) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        Assert.notNull((Object)eventId, (String)"EventId must not be null");
        EventGetQueryBuilderImpl builder = new EventGetQueryBuilderImpl("https://www.googleapis.com/calendar/v3/calendars/{0}/events/{1}", calendarId, eventId);
        return (Event)this.restTemplate.getForObject(builder.buildUri(), Event.class);
    }

    @Override
    public Event quickAddEvent(String calendarId, String specification, boolean sendNotifications) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        Assert.notNull((Object)specification, (String)"Specification must not be null");
        QuickAddEventBuilderImpl builder = new QuickAddEventBuilderImpl("https://www.googleapis.com/calendar/v3/calendars/{0}/events/quickAdd", calendarId);
        builder.text(specification).sendNotifications(sendNotifications);
        return (Event)this.restTemplate.postForObject(builder.buildUri(), null, Event.class);
    }

    @Override
    public void deleteEvent(String calendarId, String eventId, boolean sendNotifications) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        Assert.notNull((Object)eventId, (String)"EventId must not be null");
        DeleteEventBuilderImpl builder = new DeleteEventBuilderImpl("https://www.googleapis.com/calendar/v3/calendars/{0}/events/{1}", calendarId, eventId);
        builder.sendNotifications(sendNotifications);
        this.restTemplate.delete(builder.buildUri());
    }

    @Override
    public void updateEvent(String calendarId, Event event, boolean sendNotifications) {
        Assert.notNull((Object)calendarId, (String)"CalendarId must not be null");
        Assert.notNull((Object)event, (String)"Event must not be null");
        UpdateEventBuilderImpl builder = new UpdateEventBuilderImpl("https://www.googleapis.com/calendar/v3/calendars/{0}/events/{1}", calendarId, event.getId());
        builder.sendNotifications(sendNotifications);
        this.restTemplate.put(builder.buildUri(), (Object)event);
    }
}

