/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.social.google.api.ApiEntity;
import org.springframework.social.google.api.plus.Person;

public class Activity
extends ApiEntity {
    private String title;
    private Date published;
    private Date updated;
    private String url;
    @JsonProperty
    private Person actor;
    @JsonProperty
    private ActivityObject object;

    public String getTitle() {
        return this.title;
    }

    public Date getPublished() {
        return this.published;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getUrl() {
        return this.url;
    }

    public Person getActor() {
        return this.actor;
    }

    public String getContent() {
        return this.object.content;
    }

    public List<Attachment> getAttachments() {
        return this.object.attachments == null ? new ArrayList() : this.object.attachments;
    }

    public int getPlusOners() {
        return this.object.plusoners.totalItems;
    }

    public int getResharers() {
        return this.object.resharers.totalItems;
    }

    public int getReplies() {
        return this.object.replies.totalItems;
    }

    public static class ActivityObject {
        @JsonProperty
        private String content;
        @JsonProperty
        private List<Attachment> attachments;
        @JsonProperty
        private TotalItemsWrapper plusoners;
        @JsonProperty
        private TotalItemsWrapper resharers;
        @JsonProperty
        private TotalItemsWrapper replies;

        public static class TotalItemsWrapper {
            @JsonProperty
            private int totalItems;
        }
    }

    @JsonTypeName(value="audio")
    public static class Audio
    extends Attachment {
    }

    @JsonTypeName(value="video")
    public static class Video
    extends Attachment {
    }

    @JsonTypeName(value="place")
    public static class Place
    extends Attachment {
    }

    @JsonTypeName(value="photo")
    public static class Photo
    extends Attachment {
    }

    @JsonTypeName(value="hangout")
    public static class Hangout
    extends Attachment {
    }

    @JsonTypeName(value="event")
    public static class Event
    extends Attachment {
    }

    @JsonTypeName(value="album")
    public static class Album
    extends Attachment {
    }

    @JsonTypeName(value="article")
    public static class Article
    extends Attachment {
    }

    @JsonTypeInfo(property="objectType", include=JsonTypeInfo.As.PROPERTY, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Article.class), @JsonSubTypes.Type(value=Photo.class), @JsonSubTypes.Type(value=Video.class), @JsonSubTypes.Type(value=Album.class), @JsonSubTypes.Type(value=Event.class), @JsonSubTypes.Type(value=Hangout.class), @JsonSubTypes.Type(value=Place.class), @JsonSubTypes.Type(value=Audio.class)})
    public static abstract class Attachment {
        private String url;
        private String displayName;
        private String content;
        @JsonProperty
        private PreviewImage image;

        public String getUrl() {
            return this.url;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getContent() {
            return this.content;
        }

        public String getPreviewImageUrl() {
            return this.image == null ? null : this.image.url;
        }

        public String getPreviewImageContentType() {
            return this.image == null ? null : this.image.type;
        }
    }

    public static class PreviewImage {
        @JsonProperty
        protected String url;
        @JsonProperty
        protected String type;
        @JsonProperty
        protected int height;
        @JsonProperty
        protected int width;
    }
}

