/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus;

public enum AgeRange {
    UNKNOWN(null, null),
    AGE_17_MINUS(null, 17),
    AGE_18_20(18, 20),
    AGE_21_PLUS(21, null);

    private Integer min;
    private Integer max;

    private AgeRange(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    public static AgeRange fromMinMax(Integer min, Integer max) {
        if (min == null && max != null && max == 17) {
            return AGE_17_MINUS;
        }
        if (min != null && min == 18 && max != null && max == 20) {
            return AGE_18_20;
        }
        if (min != null && min == 21 && max == null) {
            return AGE_21_PLUS;
        }
        AgeRange unknown = UNKNOWN;
        unknown.min = min;
        unknown.max = max;
        return unknown;
    }

    public Integer getMin() {
        return this.min;
    }

    public Integer getMax() {
        return this.max;
    }
}

