/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.plus.impl;

import org.springframework.social.google.api.impl.AbstractGoogleApiOperations;
import org.springframework.social.google.api.plus.ActivitiesPage;
import org.springframework.social.google.api.plus.Activity;
import org.springframework.social.google.api.plus.ActivityComment;
import org.springframework.social.google.api.plus.ActivityCommentsPage;
import org.springframework.social.google.api.plus.ActivityQueryBuilder;
import org.springframework.social.google.api.plus.PeoplePage;
import org.springframework.social.google.api.plus.Person;
import org.springframework.social.google.api.plus.PersonQueryBuilder;
import org.springframework.social.google.api.plus.PlusOperations;
import org.springframework.social.google.api.plus.impl.ActivityQueryBuilderImpl;
import org.springframework.social.google.api.plus.impl.PersonQueryBuilderImpl;
import org.springframework.social.google.api.plus.moments.Moment;
import org.springframework.social.google.api.plus.moments.MomentQueryBuilder;
import org.springframework.social.google.api.plus.moments.MomentsPage;
import org.springframework.social.google.api.plus.moments.impl.MomentQueryBuilderImpl;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class PlusTemplate
extends AbstractGoogleApiOperations
implements PlusOperations {
    static final String PEOPLE_SEARCH_URL = "https://www.googleapis.com/plus/v1/people";
    private static final String PEOPLE_URL = "https://www.googleapis.com/plus/v1/people/";
    private static final String ACTIVITIES_PUBLIC = "/activities/public";
    private static final String ACTIVITIES_URL = "https://www.googleapis.com/plus/v1/activities/";
    private static final String COMMENTS_URL = "https://www.googleapis.com/plus/v1/comments/";
    private static final String COMMENTS = "/comments";
    private static final String PLUSONERS = "/people/plusoners";
    private static final String RESHARERS = "/people/resharers";
    private static final String MOMENTS_URL = "https://www.googleapis.com/plus/v1/people/me/moments/vault";

    public PlusTemplate(RestTemplate restTemplate, boolean isAuthorized) {
        super(restTemplate, isAuthorized);
    }

    @Override
    public Activity getActivity(String id) {
        return this.getEntity(ACTIVITIES_URL + id, Activity.class);
    }

    @Override
    public ActivitiesPage getActivities(String userId, String pageToken) {
        StringBuilder sb = new StringBuilder(PEOPLE_URL).append(userId).append(ACTIVITIES_PUBLIC);
        if (pageToken != null) {
            sb.append("?pageToken=").append(pageToken);
        }
        return this.getEntity(sb.toString(), ActivitiesPage.class);
    }

    @Override
    public ActivitiesPage getActivities(String userId) {
        return this.getActivities(userId, null);
    }

    @Override
    public ActivitiesPage searchPublicActivities(String query, String pageToken) {
        return (ActivitiesPage)((ActivityQueryBuilder)this.activityQuery().searchFor(query).fromPage(pageToken)).getPage();
    }

    @Override
    public ActivityQueryBuilder activityQuery() {
        return new ActivityQueryBuilderImpl(this.restTemplate);
    }

    @Override
    public ActivityComment getComment(String id) {
        return this.getEntity(COMMENTS_URL + id, ActivityComment.class);
    }

    @Override
    public ActivityCommentsPage getComments(String activityId, String pageToken) {
        StringBuilder sb = new StringBuilder(ACTIVITIES_URL).append(activityId).append(COMMENTS);
        if (StringUtils.hasText((String)pageToken)) {
            sb.append("?pageToken=").append(pageToken);
        }
        return this.getEntity(sb.toString(), ActivityCommentsPage.class);
    }

    @Override
    public Person getPerson(String id) {
        return this.getEntity(PEOPLE_URL + id, Person.class);
    }

    @Override
    public Person getGoogleProfile() {
        return this.getPerson("me");
    }

    @Override
    public PersonQueryBuilder personQuery() {
        return new PersonQueryBuilderImpl(this.restTemplate);
    }

    @Override
    public PeoplePage getPeopleInCircles(String id, String pageToken) {
        StringBuilder sb = new StringBuilder(PEOPLE_URL).append(id).append("/people/visible");
        if (StringUtils.hasText((String)pageToken)) {
            sb.append("?pageToken=").append(pageToken);
        }
        return this.getEntity(sb.toString(), PeoplePage.class);
    }

    @Override
    public PeoplePage searchPeople(String query, String pageToken) {
        return (PeoplePage)((PersonQueryBuilder)this.personQuery().searchFor(query).fromPage(pageToken)).getPage();
    }

    @Override
    public PeoplePage getActivityPlusOners(String activityId, String pageToken) {
        return this.getEntity(ACTIVITIES_URL + activityId + PLUSONERS, PeoplePage.class);
    }

    @Override
    public PeoplePage getActivityResharers(String activityId, String pageToken) {
        return this.getEntity(ACTIVITIES_URL + activityId + RESHARERS, PeoplePage.class);
    }

    @Override
    public Moment insertMoment(Moment moment) {
        return this.saveEntity(MOMENTS_URL, moment);
    }

    @Override
    public MomentQueryBuilder momentQuery() {
        return new MomentQueryBuilderImpl(MOMENTS_URL, this.restTemplate);
    }

    @Override
    public MomentsPage getMoments(String pageToken) {
        return (MomentsPage)this.momentQuery().getPage();
    }

    @Override
    public void deleteMoment(String id) {
        this.deleteEntity("https://www.googleapis.com/plus/v1/moments", id);
    }
}

