/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.security;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.security.SocialAuthenticationToken;
import org.springframework.social.security.SocialUserDetails;
import org.springframework.social.security.SocialUserDetailsService;
import org.springframework.util.Assert;

public class SocialAuthenticationProvider
implements AuthenticationProvider {
    private UsersConnectionRepository usersConnectionRepository;
    private SocialUserDetailsService userDetailsService;

    public SocialAuthenticationProvider(UsersConnectionRepository usersConnectionRepository, SocialUserDetailsService userDetailsService) {
        this.usersConnectionRepository = usersConnectionRepository;
        this.userDetailsService = userDetailsService;
    }

    public boolean supports(Class<? extends Object> authentication) {
        return SocialAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.isInstanceOf(SocialAuthenticationToken.class, (Object)authentication, (String)"unsupported authentication type");
        Assert.isTrue((!authentication.isAuthenticated() ? 1 : 0) != 0, (String)"already authenticated");
        SocialAuthenticationToken authToken = (SocialAuthenticationToken)authentication;
        String providerId = authToken.getProviderId();
        Connection<?> connection = authToken.getConnection();
        String userId = this.toUserId(connection);
        if (userId == null) {
            throw new BadCredentialsException("Unknown access token");
        }
        SocialUserDetails userDetails = this.userDetailsService.loadUserByUserId(userId);
        if (userDetails == null) {
            throw new UsernameNotFoundException("Unknown connected account id");
        }
        return new SocialAuthenticationToken(connection, (Serializable)((Object)userDetails), authToken.getProviderAccountData(), this.getAuthorities(providerId, userDetails));
    }

    protected String toUserId(Connection<?> connection) {
        List userIds = this.usersConnectionRepository.findUserIdsWithConnection(connection);
        return userIds.size() == 1 ? (String)userIds.iterator().next() : null;
    }

    protected Collection<? extends GrantedAuthority> getAuthorities(String providerId, UserDetails userDetails) {
        return userDetails.getAuthorities();
    }
}

