/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.client.api.ep.EntityStream;
import org.apache.olingo.odata2.client.core.ep.deserializer.JsonEntryDeserializer;
import org.apache.olingo.odata2.client.core.ep.deserializer.JsonFeedDeserializer;
import org.apache.olingo.odata2.client.core.ep.deserializer.JsonPropertyDeserializer;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class JsonEntityDeserializer {
    private static final String DEFAULT_CHARSET = "UTF-8";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataEntry readEntry(EdmEntitySet entitySet, EntityStream entityStream) throws EntityProviderException {
        ODataEntry oDataEntry;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            EntityInfoAggregator eia = EntityInfoAggregator.create((EdmEntitySet)entitySet);
            reader = this.createJsonReader(entityStream.getContent());
            oDataEntry = new JsonEntryDeserializer(reader, eia, entityStream.getReadProperties()).readSingleEntry();
            if (reader == null) return oDataEntry;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e2.getClass().getSimpleName()}), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataEntry;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    public ODataFeed readFeed(EdmEntitySet entitySet, EntityStream entityStream) throws EntityProviderException {
        return this.readDeltaFeed(entitySet, entityStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataDeltaFeed readDeltaFeed(EdmEntitySet entitySet, EntityStream entityStream) throws EntityProviderException {
        ODataDeltaFeed oDataDeltaFeed;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            EntityInfoAggregator eia = EntityInfoAggregator.create((EdmEntitySet)entitySet);
            reader = this.createJsonReader(entityStream.getContent());
            JsonFeedDeserializer jfc = new JsonFeedDeserializer(reader, eia, entityStream.getReadProperties());
            oDataDeltaFeed = jfc.readFeedStandalone();
            if (reader == null) return oDataDeltaFeed;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e2.getClass().getSimpleName()}), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataDeltaFeed;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private JsonReader createJsonReader(Object content) throws EntityProviderException, UnsupportedEncodingException {
        if (content == null) {
            throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Got not supported NULL object as content to de-serialize."}));
        }
        if (content instanceof InputStream) {
            return new JsonReader((Reader)new InputStreamReader((InputStream)content, DEFAULT_CHARSET));
        }
        throw new EntityProviderException(EntityProviderException.ILLEGAL_ARGUMENT.addContent(new Object[]{"Found not supported content of class '" + content.getClass() + "' to de-serialize."}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<?> readCollection(EntityPropertyInfo info, EntityStream entityStream) throws EntityProviderException {
        List<?> list;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(entityStream.getContent());
            list = new JsonPropertyDeserializer().readCollection(reader, info, entityStream.getReadProperties());
            if (reader == null) return list;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e2.getClass().getSimpleName()}), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> readProperty(EntityPropertyInfo propertyInfo, EntityStream entityStream) throws EntityProviderException {
        Map<String, Object> map;
        JsonReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = this.createJsonReader(entityStream.getContent());
            map = new JsonPropertyDeserializer().readPropertyStandalone(reader, propertyInfo, entityStream.getReadProperties());
            if (reader == null) return map;
        }
        catch (UnsupportedEncodingException e) {
            try {
                cachedException = new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e2.getClass().getSimpleName()}), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return map;
        }
        catch (IOException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

