/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.client.api.uri.EdmURIBuilder;
import org.apache.olingo.odata2.client.api.uri.QueryOption;
import org.apache.olingo.odata2.client.api.uri.SegmentType;
import org.apache.olingo.odata2.client.core.uri.Segment;
import org.apache.olingo.odata2.client.core.uri.util.UriUtil;
import org.apache.olingo.odata2.core.commons.Encoder;

public class EdmURIBuilderImpl
implements EdmURIBuilder {
    protected final List<Segment> segments = new ArrayList<Segment>();
    private SegmentType state = SegmentType.INITIAL;
    protected final Map<String, String> queryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, String> customQueryOptions = new LinkedHashMap<String, String>();
    protected final Map<String, Object> functionImportParameters = new LinkedHashMap<String, Object>();

    public EdmURIBuilderImpl(String serviceRoot) {
        this.state = SegmentType.INITIAL;
        this.segments.add(new Segment(SegmentType.INITIAL, serviceRoot));
    }

    public EdmURIBuilder appendCountSegment() {
        switch (this.state) {
            case INITIAL: 
            case SIMPLEPROPERTY: 
            case COMPLEXPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case FUNCTIONIMPORT_WITH_KEY: 
            case ENTITY: {
                throw new RuntimeException("Can't specify a key at this position");
            }
            case ENTITYSET: {
                this.appendCount();
                break;
            }
            case NAVIGATION_TO_MANY: {
                this.appendCount();
                break;
            }
            case FUNCTIONIMPORT_MANY: {
                this.appendCount();
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void appendCount() {
        this.segments.add(new Segment(SegmentType.COUNT, SegmentType.COUNT.getValue()));
        this.state = SegmentType.COUNT;
    }

    public EdmURIBuilder appendValueSegment() {
        switch (this.state) {
            case INITIAL: 
            case COMPLEXPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case ENTITY: 
            case ENTITYSET: 
            case NAVIGATION_TO_MANY: {
                throw new RuntimeException("Can't specify a navigation at this position");
            }
            case SIMPLEPROPERTY: {
                this.addValueSegment();
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void addValueSegment() {
        this.segments.add(new Segment(SegmentType.VALUE, SegmentType.VALUE.getValue()));
    }

    public EdmURIBuilder appendMetadataSegment() {
        this.segments.add(new Segment(SegmentType.METADATA, SegmentType.METADATA.getValue()));
        return this;
    }

    public EdmURIBuilder format(String format) {
        switch (this.state) {
            case INITIAL: 
            case COUNT: 
            case VALUE: {
                throw new RuntimeException("Can't specify a format at this position");
            }
            case SIMPLEPROPERTY: 
            case COMPLEXPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case ENTITY: 
            case ENTITYSET: 
            case NAVIGATION_TO_MANY: {
                this.addFormat(format);
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void addFormat(String format) {
        this.addQueryOption(QueryOption.FORMAT.toString(), format, true);
    }

    public EdmURIBuilder appendEntitySetSegment(EdmEntitySet entitySet) {
        this.state = SegmentType.ENTITYSET;
        try {
            this.segments.add(new Segment(SegmentType.ENTITYSET, entitySet.getName()));
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        return this;
    }

    public EdmURIBuilder appendNavigationSegment(EdmNavigationProperty property) {
        switch (this.state) {
            case INITIAL: 
            case SIMPLEPROPERTY: 
            case COMPLEXPROPERTY: 
            case ENTITYSET: 
            case NAVIGATION_TO_MANY: 
            case FUNCTIONIMPORT_MANY: {
                throw new RuntimeException("Can't specify a navigation at this position");
            }
            case NAVIGATION_TO_ONE: {
                this.addNavigationSegment(property);
                break;
            }
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case FUNCTIONIMPORT_WITH_KEY: 
            case ENTITY: {
                this.addNavigationSegment(property);
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void addNavigationSegment(EdmNavigationProperty property) {
        try {
            this.state = property.getMultiplicity() == EdmMultiplicity.MANY ? SegmentType.NAVIGATION_TO_MANY : SegmentType.NAVIGATION_TO_ONE;
            this.segments.add(new Segment(this.state, property.getName()));
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
    }

    public EdmURIBuilder appendKeySegment(EdmProperty property, Object value) {
        switch (this.state) {
            case INITIAL: 
            case SIMPLEPROPERTY: 
            case COMPLEXPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case FUNCTIONIMPORT_WITH_KEY: 
            case ENTITY: 
            case FUNCTIONIMPORT: {
                throw new RuntimeException("Can't specify a key at this position");
            }
            case ENTITYSET: {
                this.state = SegmentType.ENTITY;
                this.appendKey(property, value);
                break;
            }
            case NAVIGATION_TO_MANY: {
                this.state = SegmentType.NAVIGATION_TO_MANY_WITH_KEY;
                this.appendKey(property, value);
                break;
            }
            case FUNCTIONIMPORT_MANY: {
                this.state = SegmentType.FUNCTIONIMPORT_WITH_KEY;
                this.appendKey(property, value);
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void appendKey(EdmProperty property, Object value) {
        String key = "";
        try {
            key = this.getKey(property, value, false);
        }
        catch (EdmSimpleTypeException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        this.segments.add(new Segment(SegmentType.KEY, key));
    }

    private String getKey(EdmProperty property, Object value, boolean isSegment) throws EdmException {
        String key = "";
        EdmSimpleType edmType = (EdmSimpleType)property.getType();
        if (value instanceof String) {
            value = Encoder.encode((String)value.toString());
        }
        key = !isSegment ? "(" + edmType.valueToString(value, EdmLiteralKind.URI, property.getFacets()) + ")" : edmType.valueToString(value, EdmLiteralKind.URI, property.getFacets());
        return key;
    }

    public EdmURIBuilder appendKeySegment(Map<EdmProperty, Object> segmentValues) {
        switch (this.state) {
            case INITIAL: 
            case SIMPLEPROPERTY: 
            case COMPLEXPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case FUNCTIONIMPORT_WITH_KEY: 
            case ENTITY: 
            case FUNCTIONIMPORT: {
                throw new RuntimeException("Can't specify a key at this position");
            }
            case ENTITYSET: {
                this.state = SegmentType.ENTITY;
                this.appendKey(segmentValues);
                break;
            }
            case NAVIGATION_TO_MANY: {
                this.state = SegmentType.NAVIGATION_TO_MANY_WITH_KEY;
                this.appendKey(segmentValues);
                break;
            }
            case FUNCTIONIMPORT_MANY: {
                this.state = SegmentType.FUNCTIONIMPORT_WITH_KEY;
                this.appendKey(segmentValues);
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void appendKey(Map<EdmProperty, Object> segmentValues) {
        String key = "";
        try {
            key = this.buildMultiKeySegment(segmentValues, ',');
        }
        catch (EdmSimpleTypeException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        this.segments.add(new Segment(SegmentType.KEY, key));
    }

    protected String buildMultiKeySegment(Map<EdmProperty, Object> segmentValues, char separator) throws EdmException {
        StringBuilder keyBuilder = new StringBuilder().append('(');
        for (Map.Entry<EdmProperty, Object> entry : segmentValues.entrySet()) {
            keyBuilder.append(entry.getKey().getName()).append('=').append(this.getKey(entry.getKey(), entry.getValue(), true));
            keyBuilder.append(separator);
        }
        keyBuilder.deleteCharAt(keyBuilder.length() - 1).append(')');
        return keyBuilder.toString();
    }

    public EdmURIBuilder filter(String filter) {
        return this.replaceQueryOption(QueryOption.FILTER, filter);
    }

    public EdmURIBuilder select(String ... selectItems) {
        return this.addQueryOption(QueryOption.SELECT, UriUtil.join(selectItems, ","));
    }

    public EdmURIBuilder orderBy(String property) {
        return this.addQueryOption(QueryOption.ORDERBY, property);
    }

    public EdmURIBuilder top(int top) {
        return this.replaceQueryOption(QueryOption.TOP, String.valueOf(top));
    }

    public EdmURIBuilder skip(int skip) {
        return this.replaceQueryOption(QueryOption.SKIP, String.valueOf(skip));
    }

    public URI build() {
        return UriUtil.getUri(this.segments, this.queryOptions, this.customQueryOptions, this.functionImportParameters);
    }

    public EdmURIBuilder addQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, false);
    }

    public EdmURIBuilder replaceQueryOption(QueryOption option, String value) {
        return this.addQueryOption(option.toString(), value, true);
    }

    public EdmURIBuilder addQueryOption(String option, String value, boolean replace) {
        if (option.equalsIgnoreCase(QueryOption.EXPAND.toString())) {
            if (this.state == SegmentType.COUNT) {
                throw new RuntimeException("Can't specify a query option " + option + " at this position");
            }
            UriUtil.appendQueryOption(option, value, this.queryOptions, replace);
        } else {
            switch (this.state) {
                case INITIAL: 
                case SIMPLEPROPERTY: 
                case COMPLEXPROPERTY: {
                    throw new RuntimeException("Can't specify a query option " + option + " at this position");
                }
                case NAVIGATION_TO_ONE: 
                case NAVIGATION_TO_MANY_WITH_KEY: 
                case ENTITY: {
                    this.entityQueryOption(option, value, replace);
                    break;
                }
                case ENTITYSET: 
                case NAVIGATION_TO_MANY: {
                    UriUtil.appendQueryOption(option, value, this.queryOptions, replace);
                    break;
                }
                case COUNT: {
                    this.countQueryOption(option, value, replace);
                    break;
                }
                default: {
                    throw new RuntimeException("Unkown state:" + this.state);
                }
            }
        }
        return this;
    }

    private void countQueryOption(String option, String value, boolean replace) {
        if (option.equalsIgnoreCase(QueryOption.SELECT.toString())) {
            throw new RuntimeException("Can't specify a query option " + option + " at this position");
        }
        UriUtil.appendQueryOption(option, value, this.queryOptions, replace);
    }

    private void entityQueryOption(String option, String value, boolean replace) {
        if (!option.equalsIgnoreCase(QueryOption.SELECT.toString())) {
            throw new RuntimeException("Can't specify a query option " + option + " at this position");
        }
        UriUtil.appendQueryOption(option, value, this.queryOptions, replace);
    }

    public EdmURIBuilder appendPropertySegment(EdmProperty property, String segmentValue) {
        switch (this.state) {
            case INITIAL: 
            case SIMPLEPROPERTY: 
            case NAVIGATION_TO_ONE: 
            case ENTITYSET: 
            case NAVIGATION_TO_MANY: 
            case FUNCTIONIMPORT_MANY: {
                throw new RuntimeException("Can't specify a property at this position");
            }
            case COMPLEXPROPERTY: {
                this.appendProperty(property, segmentValue);
                break;
            }
            case ENTITY: {
                this.appendProperty(property, segmentValue);
                break;
            }
            case NAVIGATION_TO_MANY_WITH_KEY: 
            case FUNCTIONIMPORT_WITH_KEY: 
            case FUNCTIONIMPORT: {
                this.appendProperty(property, segmentValue);
                break;
            }
            default: {
                throw new RuntimeException("Unkown state:" + this.state);
            }
        }
        return this;
    }

    private void appendProperty(EdmProperty property, String segmentValue) {
        try {
            this.state = property.getType().getKind() == EdmTypeKind.SIMPLE ? SegmentType.SIMPLEPROPERTY : SegmentType.COMPLEXPROPERTY;
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        this.segments.add(new Segment(this.state, segmentValue));
    }

    public EdmURIBuilder expand(String ... expandItems) {
        return this.addQueryOption(QueryOption.EXPAND, UriUtil.join(expandItems, ","));
    }

    public EdmURIBuilder addCustomQueryOption(String paramName, Object paramValue) {
        UriUtil.appendQueryOption(paramName, paramValue.toString(), this.customQueryOptions, true);
        return this;
    }

    public EdmURIBuilder appendFunctionImportSegment(EdmFunctionImport functionImport) {
        try {
            this.state = functionImport.getReturnType() != null ? (functionImport.getReturnType().getMultiplicity() == EdmMultiplicity.MANY && functionImport.getReturnType().getType().getKind() == EdmTypeKind.ENTITY ? SegmentType.FUNCTIONIMPORT_MANY : SegmentType.FUNCTIONIMPORT) : SegmentType.FUNCTIONIMPORT;
            this.segments.add(new Segment(this.state, functionImport.getName()));
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        return this;
    }

    public EdmURIBuilder appendFunctionImportParameters(Map<EdmParameter, Object> functionImportParams) {
        try {
            if (functionImportParams != null) {
                for (Map.Entry<EdmParameter, Object> param : functionImportParams.entrySet()) {
                    EdmParameter edmParam = param.getKey();
                    EdmSimpleType edmType = (EdmSimpleType)edmParam.getType();
                    Object value = param.getValue();
                    if (value instanceof String) {
                        value = value.toString();
                    }
                    value = edmType.valueToString(value, EdmLiteralKind.URI, edmParam.getFacets());
                    this.functionImportParameters.put(edmParam.getName(), value);
                }
            }
        }
        catch (EdmException e) {
            throw new RuntimeException("Unexpected EDM Exception: ", e);
        }
        return this;
    }
}

